/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.commands;

import com.sixtyfour.cbmnative.NativeCompiler;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.Variable;
import com.sixtyfour.elements.commands.AbstractCommand;
import com.sixtyfour.elements.commands.Next;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.parser.Term;
import com.sixtyfour.parser.TermEnhancer;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.BasicProgramCounter;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.ArrayList;
import java.util.List;

public class For
extends AbstractCommand {
    private Variable var;
    private Term endTerm;
    private Term stepTerm;
    private float end;
    private float step = 1.0f;
    private boolean running = false;

    public For() {
        super("FOR");
    }

    public Variable getVar() {
        return this.var;
    }

    public void setVar(Variable var) {
        this.var = var;
    }

    @Override
    public Type getType() {
        return this.var.getType();
    }

    @Override
    public List<Term> getAllTerms() {
        ArrayList<Term> ret = new ArrayList<Term>();
        ret.add(this.term);
        ret.add(this.endTerm);
        ret.add(this.stepTerm);
        return ret;
    }

    @Override
    public String parse(CompilerConfig config, String linePart, int lineCnt, int lineNumber, int linePos, boolean lastPos, Machine machine) {
        super.parse(config, linePart, lineCnt, lineNumber, linePos, lastPos, machine);
        linePart = TermEnhancer.removeWhiteSpace(linePart.substring(this.name.length()));
        String uLinePart = VarUtils.toUpper(linePart);
        int posTo = uLinePart.indexOf("TO");
        int posStep = uLinePart.indexOf("STEP");
        if (posTo == -1) {
            throw new RuntimeException("FOR without TO: " + linePart);
        }
        String assignment = linePart.substring(0, posTo);
        this.var = Parser.getVariable(assignment, machine);
        this.term = Parser.getTerm(config, assignment, machine, true, true);
        if (this.var.getType() == Type.INTEGER) {
            this.syntaxError(linePart);
        }
        if (!(this.var.getType().equals((Object)this.term.getType()) || this.var.getType().equals((Object)Type.REAL) && this.term.getType().equals((Object)Type.INTEGER))) {
            this.typeMismatch(linePart);
        }
        String toTxt = null;
        String stepTxt = null;
        toTxt = posStep == -1 ? linePart.substring(posTo + 2) : linePart.substring(posTo + 2, posStep);
        this.endTerm = Parser.getTerm(config, toTxt, machine, false, true);
        stepTxt = posStep != -1 ? linePart.substring(posStep + 4) : "1";
        this.stepTerm = Parser.getTerm(config, stepTxt, machine, false, true);
        if (!Parser.isNumberType(this.endTerm)) {
            this.typeMismatch(this.endTerm);
        }
        if (!Parser.isNumberType(this.stepTerm)) {
            this.typeMismatch(this.stepTerm);
        }
        machine.trackVariableUsage(this.var, false);
        return null;
    }

    @Override
    public BasicProgramCounter execute(CompilerConfig config, Machine machine) {
        this.var = machine.add(this.var);
        this.var.setValue(this.term.eval(machine));
        this.end = VarUtils.getFloat(this.endTerm.eval(machine));
        this.step = VarUtils.getFloat(this.stepTerm.eval(machine));
        machine.pushFor(this);
        this.running = true;
        return null;
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        this.var = machine.add(this.var);
        NativeCompiler compiler = NativeCompiler.getCompiler();
        ArrayList<String> after = new ArrayList<String>();
        List<String> expr = compiler.compileToPseudoCode(config, machine, this.term);
        List<String> before = null;
        String varLabel = String.valueOf(this.var.getName()) + "{" + (Object)((Object)this.var.getType()) + "}";
        String expPush = this.getPushRegister(expr.get(expr.size() - 1));
        expr = expr.subList(0, expr.size() - 1);
        after.add("MOV " + varLabel + "," + expPush);
        after.addAll(compiler.compileToPseudoCode(config, machine, this.endTerm));
        after.addAll(compiler.compileToPseudoCode(config, machine, this.stepTerm));
        after.add("MOV A,(" + varLabel + ")");
        after.add("JSR INITFOR");
        CodeContainer cc = new CodeContainer(before, expr, after);
        ArrayList<CodeContainer> ccs = new ArrayList<CodeContainer>();
        ccs.add(cc);
        return ccs;
    }

    public Term getEndTerm() {
        return this.endTerm;
    }

    public boolean next(Next next, Machine machine) {
        if (next.getVarName() != null && !next.getVarName().equalsIgnoreCase(this.var.getName())) {
            throw new RuntimeException("NEXT without FOR: " + next);
        }
        if (!this.running) {
            return false;
        }
        float cur = this.var.inc(this.step);
        if (this.step > 0.0f && cur <= this.end || this.step < 0.0f && cur >= this.end) {
            return true;
        }
        if (this.running) {
            For these = machine.popFor(this);
            if (these == null) {
                throw new RuntimeException("Out of memory error: " + this);
            }
            this.running = false;
        }
        return false;
    }

    public void setToFinalValue(Machine machine) {
        this.var.setValue(Float.valueOf(VarUtils.getFloat(this.endTerm.eval(machine)) + 1.0f));
    }

    public int getSteps(Machine machine) {
        float s = VarUtils.getFloat(this.term.eval(machine));
        float e = VarUtils.getFloat(this.endTerm.eval(machine));
        float stp = VarUtils.getFloat(this.stepTerm.eval(machine));
        return (int)Math.abs((double)((e - s) / stp) + 0.5);
    }
}

