/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.commands;

import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.Variable;
import com.sixtyfour.elements.commands.MultiVariableCommand;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.parser.Term;
import com.sixtyfour.parser.TermEnhancer;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.BasicProgramCounter;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.List;

public class Get
extends MultiVariableCommand {
    public Get() {
        super("GET");
    }

    protected Get(String name) {
        super(name);
    }

    @Override
    public Type getType() {
        return Type.NONE;
    }

    @Override
    public String parse(CompilerConfig config, String linePart, int lineCnt, int lineNumber, int linePos, boolean lastPos, Machine machine) {
        super.parse(config, linePart, lineCnt, lineNumber, linePos, lastPos, machine);
        linePart = TermEnhancer.removeWhiteSpace(linePart);
        linePart = linePart.substring(3).trim();
        if (linePart.length() == 0) {
            this.syntaxError(this);
        }
        this.fillVariables(config, linePart, machine);
        return null;
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        return this.evalToCode(config, machine, "GETSTR", "GETNUMBER");
    }

    @Override
    public BasicProgramCounter execute(CompilerConfig config, Machine machine) {
        int i = 0;
        while (i < this.vars.size()) {
            Term indexTerm = (Term)this.indexTerms.get(i);
            Variable var = this.getVariable(machine, i);
            Character input = machine.getInputProvider().readKey();
            if (indexTerm != null) {
                List<Atom> pars = Parser.getParameters(indexTerm);
                int[] pis = new int[pars.size()];
                int cnt = 0;
                for (Atom par : pars) {
                    pis[cnt++] = VarUtils.getInt(par.eval(machine));
                }
                if (var.getType().equals((Object)Type.STRING)) {
                    if (input == null) {
                        var.setValue("", pis);
                    } else {
                        var.setValue(input.toString(), pis);
                    }
                } else if (input == null) {
                    var.setValue(0, pis);
                } else {
                    input = this.ensureNumberKey(machine, input, true);
                    var.setValue(Integer.valueOf(input.toString()), pis);
                }
            } else if (var.getType().equals((Object)Type.STRING)) {
                if (input == null) {
                    var.setValue("");
                } else {
                    var.setValue(input.toString());
                }
            } else if (input == null) {
                var.setValue(0);
            } else {
                input = this.ensureNumberKey(machine, input, true);
                var.setValue(Integer.valueOf(input.toString()));
            }
            ++i;
        }
        machine.getOutputChannel().setPrintConsumer(null, 0);
        return null;
    }
}

