/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.commands;

import com.sixtyfour.cbmnative.NativeCompiler;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.Variable;
import com.sixtyfour.elements.commands.Get;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.parser.Term;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.BasicProgramCounter;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.ArrayList;
import java.util.List;

public class GetFile
extends Get {
    private Atom fileNumber = null;

    public GetFile() {
        super("GET#");
    }

    @Override
    public String parse(CompilerConfig config, String linePart, int lineCnt, int lineNumber, int linePos, boolean lastPos, Machine machine) {
        int pos = (linePart = linePart.substring(this.name.length())).indexOf(44);
        if (pos == -1) {
            pos = linePart.length();
        }
        this.term = Parser.getTerm(config, linePart.substring(0, pos), machine, false, true);
        linePart = pos != linePart.length() ? linePart.substring(pos + 1) : "";
        List<Atom> pars = Parser.getParameters(this.term);
        if (pars.size() != 1) {
            this.syntaxError(this);
        }
        this.fileNumber = pars.get(0);
        this.checkTypes(pars, linePart, Type.STRING);
        super.parse(config, "GET" + linePart, lineCnt, lineNumber, linePos, lastPos, machine);
        return null;
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        NativeCompiler compiler = NativeCompiler.getCompiler();
        ArrayList<String> after = new ArrayList<String>();
        List<String> expr = null;
        ArrayList<String> before = new ArrayList<String>();
        expr = compiler.compileToPseudoCode(config, machine, this.fileNumber);
        CodeContainer cc = new CodeContainer(before, expr, after);
        ArrayList<CodeContainer> ccs = new ArrayList<CodeContainer>();
        ccs.add(cc);
        ccs.addAll(this.evalToCodeFile(config, machine, "GETSTRCHANNEL", "GETNUMBERCHANNEL"));
        return ccs;
    }

    @Override
    public BasicProgramCounter execute(CompilerConfig config, Machine machine) {
        int i = 0;
        while (i < this.vars.size()) {
            Term indexTerm = (Term)this.indexTerms.get(i);
            Variable var = this.getVariable(machine, i);
            Character input = Character.valueOf(machine.getDeviceProvider().getChar(VarUtils.getInt(this.fileNumber.eval(machine))));
            if (input.charValue() == '\u0000') {
                input = Character.valueOf(' ');
            }
            if (indexTerm != null) {
                List<Atom> pars = Parser.getParameters(indexTerm);
                int[] pis = new int[pars.size()];
                int cnt = 0;
                for (Atom par : pars) {
                    pis[cnt++] = VarUtils.getInt(par.eval(machine));
                }
                if (var.getType().equals((Object)Type.STRING)) {
                    var.setValue(input.toString(), pis);
                } else {
                    input = this.ensureNumberKey(machine, input, false);
                    var.setValue(input.toString(), pis);
                }
            } else if (var.getType().equals((Object)Type.STRING)) {
                var.setValue(input.toString());
            } else {
                input = this.ensureNumberKey(machine, input, false);
                var.setValue(input.toString());
            }
            ++i;
        }
        machine.getOutputChannel().setPrintConsumer(null, 0);
        return null;
    }
}

