/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.commands;

import com.sixtyfour.cbmnative.Util;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.commands.AbstractCommand;
import com.sixtyfour.elements.commands.Jump;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.BasicProgramCounter;
import com.sixtyfour.system.Machine;
import java.util.ArrayList;
import java.util.List;

public class Gosub
extends AbstractCommand
implements Jump {
    private BasicProgramCounter pc = new BasicProgramCounter(0, 0);
    private int targetLineNumber = 0;

    public Gosub() {
        super("GOSUB");
    }

    @Override
    public String parse(CompilerConfig config, String linePart, int lineCnt, int lineNumber, int linePos, boolean lastPos, Machine machine) {
        super.parse(config, linePart, lineCnt, lineNumber, linePos, lastPos, machine);
        linePart = linePart.substring(5).trim();
        if (linePart.isEmpty()) {
            linePart = "0";
        }
        try {
            this.targetLineNumber = Integer.parseInt(linePart);
        }
        catch (Exception e) {
            throw new RuntimeException("Undef'd statement error: " + this);
        }
        return null;
    }

    @Override
    public BasicProgramCounter execute(CompilerConfig config, Machine machine) {
        this.pc.setLineNumber(this.targetLineNumber);
        machine.push(this);
        return this.pc;
    }

    public int getTargetLineNumber() {
        return this.targetLineNumber;
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        return Util.createSingleCommand("JSR GOSUB", "JSR " + this.targetLineNumber);
    }

    @Override
    public List<Integer> getTargetLineNumbers() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        ret.add(this.targetLineNumber);
        return ret;
    }
}

