/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.commands;

import com.sixtyfour.cbmnative.NativeCompiler;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.commands.AbstractCommand;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.parser.Term;
import com.sixtyfour.parser.TermEnhancer;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.BasicProgramCounter;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.ArrayList;
import java.util.List;

public class If
extends AbstractCommand {
    private static boolean compatibleConditionalBranches = true;
    private static int ifCount = 0;
    private Term logicTerm = null;
    private BasicProgramCounter pc = new BasicProgramCounter(0, 0);
    private String conditionalTerm = null;

    public If() {
        super("IF");
    }

    @Override
    public String parse(CompilerConfig config, String linePart, int lineCnt, int lineNumber, int linePos, boolean lastPos, Machine machine) {
        super.parse(config, linePart, lineCnt, lineNumber, linePos, lastPos, machine);
        linePart = TermEnhancer.removeWhiteSpace(linePart);
        String uPart = Parser.replaceStrings(linePart, '.');
        int tp = uPart.indexOf("THEN");
        int gp = uPart.indexOf("GOTO");
        if (tp == -1 && gp == -1) {
            throw new RuntimeException("Conditional block missing: " + this);
        }
        int termEnd = 99999999;
        boolean isGoto = false;
        if (tp != -1) {
            termEnd = tp;
        }
        if (gp != -1 && gp < termEnd) {
            termEnd = gp;
            isGoto = true;
        }
        this.conditionalTerm = linePart.substring(2, termEnd);
        this.logicTerm = Parser.getTerm(config, this.conditionalTerm, machine, false, true);
        if (isGoto) {
            return linePart.substring(termEnd);
        }
        String restTerm = linePart.substring(termEnd + 4);
        if (Parser.isInteger(restTerm)) {
            return "GOTO" + restTerm;
        }
        return restTerm;
    }

    @Override
    public List<Term> getAllTerms() {
        ArrayList<Term> ret = new ArrayList<Term>();
        ret.add(this.logicTerm);
        return ret;
    }

    @Override
    public BasicProgramCounter execute(CompilerConfig config, Machine machine) {
        this.pc.setSkip(false);
        boolean ok = this.evalToBoolean(machine, this.logicTerm);
        if (ok) {
            return null;
        }
        this.pc.setSkip(true);
        return this.pc;
    }

    private boolean evalToBoolean(Machine machine, Term term) {
        Object res = this.logicTerm.eval(machine);
        if (VarUtils.isNumber(res)) {
            int ret = VarUtils.getInt(res);
            return ret == -1;
        }
        return false;
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        NativeCompiler compiler = NativeCompiler.getCompiler();
        ArrayList<String> after = new ArrayList<String>();
        Term cTerm = Parser.getTerm(config, this.conditionalTerm, machine, false, true);
        int ic = ifCount++;
        String label = "SKIP" + ic;
        List<String> expr = compiler.compileToPseudoCode(config, machine, cTerm);
        List<String> before = null;
        String expPush = this.getPushRegister(expr.get(expr.size() - 1));
        expr = expr.subList(0, expr.size() - 1);
        if (!compatibleConditionalBranches) {
            after.add("CMP " + expPush + ",#0{REAL}");
            after.add("JE " + label);
            after.add(String.valueOf(label) + ":");
        } else {
            after.add("CMP " + expPush + ",#0{REAL}");
            after.add("JNE N" + label);
            after.add("JMP " + label);
            after.add("N" + label + ":");
            after.add(String.valueOf(label) + ":");
        }
        CodeContainer cc = new CodeContainer(before, expr, after);
        ArrayList<CodeContainer> ccs = new ArrayList<CodeContainer>();
        ccs.add(cc);
        return ccs;
    }

    public Term getLogicTerm() {
        return this.logicTerm;
    }

    @Override
    public boolean isConditional() {
        return true;
    }
}

