/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.commands;

import com.sixtyfour.cbmnative.NativeCompiler;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.Variable;
import com.sixtyfour.elements.commands.AbstractCommand;
import com.sixtyfour.elements.commands.Assignment;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.parser.Term;
import com.sixtyfour.parser.VariableAndIndex;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.BasicProgramCounter;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.ArrayList;
import java.util.List;

public class Let
extends AbstractCommand
implements Assignment {
    private Variable var;
    private Term indexTerm;
    private int[] pis;

    public Let() {
        super("LET");
    }

    @Override
    public Variable getVar() {
        return this.var;
    }

    public void setVar(Variable var) {
        this.var = var;
    }

    @Override
    public Type getType() {
        return this.var.getType();
    }

    @Override
    public String parse(CompilerConfig config, String linePart, int lineCnt, int lineNumber, int linePos, boolean lastPos, Machine machine) {
        super.parse(config, linePart, lineCnt, lineNumber, linePos, lastPos, machine);
        if (VarUtils.toUpper(linePart).startsWith("LET")) {
            linePart = linePart.substring(3).trim();
        }
        boolean varExist = Parser.hasVariableAdded(linePart, machine, true);
        this.var = Parser.getVariable(linePart, machine);
        VariableAndIndex vai = Parser.getIndexTerm(config, this.var, linePart, machine, true);
        this.indexTerm = vai.getIndexTerm();
        this.var = vai.getVariable();
        this.term = Parser.getTerm(config, linePart, machine, true, true);
        if (this.term.getOperator().isDelimiter()) {
            this.syntaxError(linePart);
        }
        if (!this.var.getType().equals((Object)this.term.getType()) && (this.var.getType().equals((Object)Type.STRING) || this.term.getType().equals((Object)Type.STRING))) {
            this.typeMismatch(linePart);
        }
        if (this.var.isReadOnly()) {
            this.syntaxError(linePart);
        }
        if (this.indexTerm != null) {
            List<Atom> pars = Parser.getParameters(this.indexTerm);
            this.pis = new int[pars.size()];
        }
        machine.trackVariableUsage(this.var, !varExist);
        return null;
    }

    @Override
    public List<Term> getAllTerms() {
        ArrayList<Term> ret = new ArrayList<Term>();
        ret.add(this.term);
        ret.add(this.indexTerm);
        return ret;
    }

    @Override
    public BasicProgramCounter execute(CompilerConfig config, Machine machine) {
        this.var = machine.add(this.var);
        if (this.indexTerm == null) {
            this.var.setValue(this.term.eval(machine));
        } else {
            List<Atom> pars = Parser.getParameters(this.indexTerm);
            int i = 0;
            while (i < pars.size()) {
                this.pis[i] = VarUtils.getInt(pars.get(i).eval(machine));
                ++i;
            }
            this.var.setValue(this.term.eval(machine), this.pis);
        }
        return null;
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        this.var = machine.add(this.var);
        NativeCompiler compiler = NativeCompiler.getCompiler();
        ArrayList<String> after = new ArrayList<String>();
        List<String> expr = compiler.compileToPseudoCode(config, machine, this.term);
        List<String> before = null;
        String expPush = this.getPushRegister(expr.get(expr.size() - 1));
        expr = expr.subList(0, expr.size() - 1);
        if (this.indexTerm != null) {
            List<Atom> pars = Parser.getParameters(this.indexTerm);
            before = compiler.compileToPseudoCode(config, machine, Parser.createIndexTerm(config, machine, pars, this.var.getDimensions()));
            if (expPush.equals("X")) {
                after.add("MOV Y,X");
            } else if (expPush.equals("B")) {
                after.add("MOV A,B");
            }
            if (!expr.get(expr.size() - 1).contains("{STRING}") && this.var.getType() == Type.STRING) {
                after.add("JSR COPYSTR");
            }
            after.add("POP X");
            after.add("MOV G," + this.getVariableLabel(config, machine, this.var));
            after.add("JSR ARRAYSTORE");
        } else {
            if (this.var.getType() == Type.STRING && !expr.get(expr.size() - 1).contains("{STRING}")) {
                if (expPush.equals("B")) {
                    after.add("MOV A,B");
                    expPush = "A";
                }
                after.add("JSR COPYSTR");
            }
            after.add("MOV " + this.getVariableLabel(config, machine, this.var) + "," + expPush);
        }
        CodeContainer cc = new CodeContainer(before, expr, after);
        ArrayList<CodeContainer> ccs = new ArrayList<CodeContainer>();
        ccs.add(cc);
        return ccs;
    }
}

