/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.commands;

import com.sixtyfour.cbmnative.NativeCompiler;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.Variable;
import com.sixtyfour.elements.commands.AbstractCommand;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.parser.Term;
import com.sixtyfour.parser.VariableAndIndex;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class MultiVariableCommand
extends AbstractCommand {
    protected List<Variable> vars = new ArrayList<Variable>();
    protected List<Term> indexTerms = new ArrayList<Term>();

    public MultiVariableCommand(String name) {
        super(name);
    }

    @Override
    public List<Term> getAllTerms() {
        ArrayList<Term> ret = new ArrayList<Term>();
        ret.add(this.term);
        ret.addAll(this.indexTerms);
        return ret;
    }

    protected final List<CodeContainer> evalToCode(CompilerConfig config, Machine machine, String strCall, String numberCall) {
        NativeCompiler compiler = NativeCompiler.getCompiler();
        ArrayList<CodeContainer> ccs = new ArrayList<CodeContainer>();
        boolean added = false;
        int i = 0;
        while (i < this.vars.size()) {
            Term indexTerm = this.indexTerms.get(i);
            Variable var = this.getVariable(machine, i);
            ArrayList<String> after = new ArrayList<String>();
            ArrayList<String> expr = new ArrayList<String>();
            ArrayList<String> before = new ArrayList<String>();
            if (var.getType() == Type.STRING) {
                expr.add("JSR " + strCall);
                if (!added) {
                    added = true;
                }
            } else if (var.getType() == Type.INTEGER || var.getType() == Type.REAL) {
                expr.add("JSR " + numberCall);
            }
            if (indexTerm != null) {
                List<Atom> pars = Parser.getParameters(indexTerm);
                before.addAll(compiler.compileToPseudoCode(config, machine, Parser.createIndexTerm(config, machine, pars, var.getDimensions())));
                after.add("POP X");
                after.add("MOV G," + this.getVariableLabel(config, machine, var));
                after.add("JSR ARRAYSTORE");
            } else {
                after.add("MOV " + this.getVariableLabel(config, machine, var) + "," + (var.getType() == Type.STRING ? "A" : "Y"));
            }
            CodeContainer cc = new CodeContainer(before, expr, after);
            ccs.add(cc);
            ++i;
        }
        return ccs;
    }

    protected final List<CodeContainer> evalToCodeFile(CompilerConfig config, Machine machine, String strCall, String numberCall) {
        NativeCompiler compiler = NativeCompiler.getCompiler();
        ArrayList<CodeContainer> ccs = new ArrayList<CodeContainer>();
        int i = 0;
        while (i < this.vars.size()) {
            Term indexTerm = this.indexTerms.get(i);
            Variable var = this.getVariable(machine, i);
            ArrayList<String> after = new ArrayList<String>();
            ArrayList<String> expr = new ArrayList();
            List<String> before = new ArrayList<String>();
            before = this.saveC(before);
            if (var.getType() == Type.STRING) {
                before.add("JSR " + strCall);
            } else if (var.getType() == Type.INTEGER || var.getType() == Type.REAL) {
                before.add("JSR " + numberCall);
            }
            if (i != this.vars.size() - 1) {
                before.add("PUSH C");
            }
            if (indexTerm != null) {
                List<Atom> pars = Parser.getParameters(indexTerm);
                expr = compiler.compileToPseudoCode(config, machine, Parser.createIndexTerm(config, machine, pars, var.getDimensions()));
                after.add("POP X");
                after.add("MOV G," + this.getVariableLabel(config, machine, var));
                after.add("JSR ARRAYSTORE");
            } else {
                after.add("MOV " + this.getVariableLabel(config, machine, var) + "," + (var.getType() == Type.STRING ? "A" : "Y"));
            }
            CodeContainer cc = new CodeContainer(before, expr, after);
            ccs.add(cc);
            ++i;
        }
        return ccs;
    }

    protected final Variable getVariable(Machine machine, int i) {
        Variable var;
        Variable oldVar = var = this.vars.get(i);
        if ((var = machine.add(var)) != oldVar) {
            this.vars.set(i, var);
        }
        return var;
    }

    protected final Character ensureNumberKey(Machine machine, Character input, boolean checkColon) {
        if (input.charValue() == '+' || input.charValue() == '-' || input.charValue() == '.' || input.charValue() == ',' || input.charValue() == 'e') {
            input = Character.valueOf('0');
        }
        if (checkColon && input.charValue() == ':') {
            machine.getOutputChannel().systemPrintln(0, "?Extra ignored:" + this);
            input = Character.valueOf('0');
        }
        if (input.charValue() < '0' || input.charValue() > '9') {
            this.syntaxError(this);
        }
        return input;
    }

    protected final void fillVariables(CompilerConfig config, String linePart, Machine machine) {
        int brackets = 0;
        StringBuilder sb = new StringBuilder();
        ArrayList<String> parts = new ArrayList<String>();
        ArrayList<String> varNames = new ArrayList<String>();
        int i = 0;
        while (i < linePart.length()) {
            char c = linePart.charAt(i);
            if (c == '(') {
                ++brackets;
            } else if (c == ')') {
                --brackets;
            }
            if (c != ',' || brackets != 0) {
                sb.append(c);
            }
            if (brackets == 0 && (c == ',' || i == linePart.length() - 1)) {
                String pa = sb.toString();
                varNames.add(Parser.getVariableName(pa));
                parts.add(pa);
                sb.setLength(0);
            }
            ++i;
        }
        int cnt = 0;
        for (String part : parts) {
            Variable var = new Variable(VarUtils.toUpper(((String)varNames.get(cnt++)).trim()), null);
            VariableAndIndex vai = Parser.getIndexTerm(config, var, part, machine, false);
            var = vai.getVariable();
            this.indexTerms.add(vai.getIndexTerm());
            this.vars.add(var);
            machine.trackVariableUsage(var, false);
        }
    }
}

