/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.commands;

import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.commands.AbstractCommand;
import com.sixtyfour.elements.commands.For;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.BasicProgramCounter;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.ArrayList;
import java.util.List;

public class Next
extends AbstractCommand {
    private String varName = null;
    private BasicProgramCounter pc = new BasicProgramCounter(0, 0);

    public Next() {
        super("NEXT");
    }

    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String varName) {
        this.varName = varName;
    }

    @Override
    public String parse(CompilerConfig config, String linePart, int lineCnt, int lineNumber, int linePos, boolean lastPos, Machine machine) {
        super.parse(config, linePart, lineCnt, lineNumber, linePos, lastPos, machine);
        linePart = VarUtils.toUpper(linePart.substring(4)).trim();
        String ret = null;
        String[] vars = linePart.split(",");
        if (vars.length > 1) {
            linePart = vars[0];
            ret = "NEXT";
            int i = 1;
            while (i < vars.length) {
                if (i > 1) {
                    ret = String.valueOf(ret) + ",";
                }
                ret = String.valueOf(ret) + vars[i];
                ++i;
            }
        }
        this.varName = Parser.getVariableName(linePart);
        if (this.varName != null && this.varName.length() == 0) {
            this.varName = null;
        }
        return ret;
    }

    @Override
    public BasicProgramCounter execute(CompilerConfig config, Machine machine) {
        For myFor = machine.peekFor(this.varName);
        if (myFor == null) {
            throw new RuntimeException("NEXT without FOR error (" + this.varName + "): " + this);
        }
        boolean iterate = myFor.next(this, machine);
        if (iterate) {
            this.pc.setLineCnt(myFor.lineCnt);
            this.pc.setLinePos(myFor.linePos);
            return this.pc;
        }
        return null;
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        ArrayList<String> after = new ArrayList<String>();
        ArrayList<String> expr = new ArrayList<String>();
        List<String> before = null;
        if (this.varName == null) {
            after.add("MOV A,#0{INTEGER}");
        } else {
            after.add("MOV A,(" + this.varName + "{})");
        }
        after.add("JSR NEXT");
        after.add("CMP A,#0{INTEGER}");
        after.add("JE ($JUMP)");
        CodeContainer cc = new CodeContainer(before, expr, after);
        ArrayList<CodeContainer> ccs = new ArrayList<CodeContainer>();
        ccs.add(cc);
        return ccs;
    }
}

