/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.commands;

import com.sixtyfour.cbmnative.NativeCompiler;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.commands.AbstractCommand;
import com.sixtyfour.elements.commands.Jump;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.BasicProgramCounter;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.ArrayList;
import java.util.List;

public class On
extends AbstractCommand
implements Jump {
    private static int onCount = 0;
    private BasicProgramCounter pc = new BasicProgramCounter(0, 0);
    private List<Integer> lineNumbers = new ArrayList<Integer>();
    private boolean gosub = false;

    public List<Integer> getLineNumbers() {
        return this.lineNumbers;
    }

    public On() {
        super("ON");
    }

    @Override
    public String parse(CompilerConfig config, String linePart, int lineCnt, int lineNumber, int linePos, boolean lastPos, Machine machine) {
        String[] parts;
        super.parse(config, linePart, lineCnt, lineNumber, linePos, lastPos, machine);
        linePart = linePart.substring(2).trim();
        String uPart = VarUtils.toUpper(linePart);
        int pos = uPart.lastIndexOf("GO");
        if (pos == -1) {
            this.syntaxError(this);
        }
        this.term = Parser.getTerm(config, linePart.substring(0, pos), machine, false, true);
        if (this.term.getType().equals((Object)Type.STRING)) {
            this.typeMismatch(linePart);
        }
        this.gosub = uPart.indexOf("GOSUB") != -1;
        int numPos = -1;
        String lines = linePart.substring(pos);
        int i = 0;
        while (i < lines.length()) {
            char c = lines.charAt(i);
            if (Character.isDigit(c)) {
                numPos = i;
                break;
            }
            ++i;
        }
        if (numPos == -1) {
            lines = "0";
            numPos = 0;
        }
        String[] stringArray = parts = lines.substring(numPos).split(",");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            try {
                if (part.length() == 0) {
                    this.lineNumbers.add(0);
                } else {
                    Integer li = Integer.valueOf(part.trim());
                    this.lineNumbers.add(li);
                }
            }
            catch (Exception e) {
                this.syntaxError(this);
            }
            ++n2;
        }
        return null;
    }

    @Override
    public BasicProgramCounter execute(CompilerConfig config, Machine machine) {
        int index = VarUtils.getInt(this.term.eval(machine));
        if (index <= 0 || index > this.lineNumbers.size()) {
            return null;
        }
        this.pc.setLineNumber(this.lineNumbers.get(index - 1));
        if (this.gosub) {
            machine.push(this);
        }
        return this.pc;
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        NativeCompiler compiler = NativeCompiler.getCompiler();
        ArrayList<String> after = new ArrayList<String>();
        List<String> expr = compiler.compileToPseudoCode(config, machine, this.term);
        List<String> before = null;
        String expPush = this.getPushRegister(expr.get(expr.size() - 1));
        expr = expr.subList(0, expr.size() - 1);
        int oc = onCount++;
        String label = "GSKIPON" + oc;
        after.add("INT " + expPush + "," + expPush);
        int i = 0;
        while (i < this.lineNumbers.size()) {
            after.add("ON" + oc + "SUB" + i + ":");
            after.add("CMP " + expPush + ",#" + (i + 1) + "{INTEGER}");
            if (this.gosub) {
                after.add("JNE " + (i == this.lineNumbers.size() - 1 ? label : "ON" + oc + "SUB" + (i + 1)));
                after.add("JSR GOSUB");
                after.add("JSR " + this.lineNumbers.get(i));
                after.add("JMP " + label);
            } else {
                String al = "AFTER" + oc + "SUB" + i;
                after.add("JNE " + al);
                after.add("JMP " + this.lineNumbers.get(i));
                after.add(String.valueOf(al) + ":");
            }
            ++i;
        }
        after.add(String.valueOf(label) + ":");
        CodeContainer cc = new CodeContainer(before, expr, after);
        ArrayList<CodeContainer> ccs = new ArrayList<CodeContainer>();
        ccs.add(cc);
        return ccs;
    }

    @Override
    public List<Integer> getTargetLineNumbers() {
        return new ArrayList<Integer>(this.lineNumbers);
    }
}

