/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.commands;

import com.sixtyfour.cbmnative.NativeCompiler;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.Variable;
import com.sixtyfour.elements.commands.AbstractCommand;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.parser.Term;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.BasicProgramCounter;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.ArrayList;
import java.util.List;

public class Poke
extends AbstractCommand {
    protected Atom addr = null;
    protected Atom val = null;

    public Poke() {
        super("POKE");
    }

    @Override
    public String parse(CompilerConfig config, String linePart, int lineCnt, int lineNumber, int linePos, boolean lastPos, Machine machine) {
        super.parse(config, linePart, lineCnt, lineNumber, linePos, lastPos, machine);
        this.term = Parser.getTerm(config, this, linePart, machine, true);
        List<Atom> pars = Parser.getParameters(this.term);
        if (pars.size() != 2) {
            this.syntaxError(this);
        }
        this.checkTypes(pars, linePart, Type.STRING, Type.STRING);
        this.addr = pars.get(0);
        this.val = pars.get(1);
        if (this.val instanceof Variable) {
            this.val = new Term(this.val);
        }
        if (this.addr instanceof Variable) {
            this.addr = new Term(this.addr);
        }
        return null;
    }

    @Override
    public List<Term> getAllTerms() {
        ArrayList<Term> ret = new ArrayList<Term>();
        if (this.addr.isTerm()) {
            ret.add((Term)this.addr);
        }
        if (this.val.isTerm()) {
            ret.add((Term)this.val);
        }
        return ret;
    }

    @Override
    public BasicProgramCounter execute(CompilerConfig config, Machine machine) {
        int memAddr = VarUtils.getInt(this.addr.eval(machine));
        int vally = VarUtils.getInt(this.val.eval(machine));
        if (vally < 0 || vally > 255 || memAddr < 0 || memAddr > 65535) {
            throw new RuntimeException("Illegal quantity error: " + this + "/" + vally + "/" + memAddr);
        }
        machine.getRam()[memAddr] = vally;
        machine.getMemoryListener().poke(memAddr, vally);
        return null;
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        NativeCompiler compiler = NativeCompiler.getCompiler();
        ArrayList<String> after = new ArrayList<String>();
        List<String> expr = compiler.compileToPseudoCode(config, machine, this.val);
        List<String> before = null;
        String expPush = this.getPushRegister(expr.get(expr.size() - 1));
        expr = expr.subList(0, expr.size() - 1);
        if (this.addr.isConstant()) {
            if (expPush.equals("Y")) {
                expr.add("MOV X,Y");
            }
            after.add("MOVB " + ((Number)this.addr.eval(machine)).intValue() + ",X");
        } else {
            before = compiler.compileToPseudoCode(config, machine, this.addr);
            if (expPush.equals("Y")) {
                expr.add("MOV X,Y");
            }
            after.add("POP Y");
            after.add("MOVB (Y),X");
        }
        CodeContainer cc = new CodeContainer(before, expr, after);
        ArrayList<CodeContainer> ccs = new ArrayList<CodeContainer>();
        ccs.add(cc);
        return ccs;
    }
}

