/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.commands;

import com.sixtyfour.cbmnative.NativeCompiler;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.commands.AbstractCommand;
import com.sixtyfour.elements.functions.Function;
import com.sixtyfour.elements.functions.FunctionList;
import com.sixtyfour.parser.Operator;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.parser.Term;
import com.sixtyfour.parser.TermEnhancer;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.parser.optimize.TermOptimizer;
import com.sixtyfour.plugins.PrintConsumer;
import com.sixtyfour.system.BasicProgramCounter;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.CompilerException;
import com.sixtyfour.util.VarUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class Print
extends AbstractCommand {
    protected List<PrintPart> parts = new ArrayList<PrintPart>();
    protected String orgLine = null;

    public Print() {
        super("PRINT");
    }

    protected Print(String name) {
        super(name);
    }

    @Override
    public Type getType() {
        return this.term.getType();
    }

    @Override
    public String parse(CompilerConfig config, String linePart, int lineCnt, int lineNumber, int linePos, boolean lastPos, Machine machine) {
        super.parse(config, linePart, lineCnt, lineNumber, linePos, lastPos, machine);
        this.orgLine = linePart;
        String aLine = linePart.substring(linePart.startsWith("?") ? 1 : 5);
        aLine = TermOptimizer.optimizePrintTerm(aLine);
        List<PrintPart> parts = this.getParts(aLine, config);
        if (parts.size() == 0) {
            PrintPart newLine = new PrintPart("\"\"", ' ');
            parts.add(newLine);
        }
        for (PrintPart part : parts) {
            part.term = Parser.getTerm(config, part.part, machine, false, true);
        }
        this.parts = parts;
        return null;
    }

    @Override
    public List<Term> getAllTerms() {
        ArrayList<Term> ret = new ArrayList<Term>();
        ret.add(this.term);
        for (PrintPart part : this.parts) {
            ret.add(part.term);
        }
        return ret;
    }

    @Override
    public BasicProgramCounter execute(CompilerConfig config, Machine machine) {
        return this.execute(machine, machine.getOutputChannel(), 0);
    }

    protected BasicProgramCounter execute(Machine machine, PrintConsumer consumer, int printId) {
        int i = 0;
        while (i < this.parts.size()) {
            double f;
            Object obj;
            PrintPart part = this.parts.get(i);
            char del = part.delimiter;
            String add = null;
            Type type = part.term.getType();
            if (del == ';' || del == ' ') {
                if (type.equals((Object)Type.INTEGER) || type.equals((Object)Type.REAL)) {
                    add = " ";
                }
                if (del == ' ' && i == this.parts.size() - 1) {
                    add = "\n";
                }
            } else if (del == ',') {
                add = "\t";
                if (type.equals((Object)Type.INTEGER) || type.equals((Object)Type.REAL)) {
                    add = " " + add;
                }
            }
            if (VarUtils.isFloat(obj = part.term.eval(machine))) {
                float f2 = ((Float)obj).floatValue();
                if (f2 == (float)((int)f2)) {
                    obj = (int)f2;
                }
            } else if (VarUtils.isDouble(obj) && (f = ((Double)obj).doubleValue()) == (double)((int)f)) {
                obj = (int)f;
            }
            if (obj == null) {
                obj = "";
            }
            String toPrint = obj.toString();
            if (VarUtils.isNumber(obj) && VarUtils.getFloat(obj) >= 0.0f) {
                toPrint = " " + toPrint;
            }
            if ("\n".equals(add)) {
                consumer.println(printId, toPrint);
            } else {
                toPrint = String.valueOf(toPrint) + (add != null ? add : "");
                consumer.print(printId, toPrint);
            }
            ++i;
        }
        return null;
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        return this.evalToCode(config, machine, "");
    }

    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine, String appendix) {
        NativeCompiler compiler = NativeCompiler.getCompiler();
        ArrayList<String> after = new ArrayList<String>();
        List<String> expr = new ArrayList<String>();
        List<String> before = null;
        try {
            int i = 0;
            while (i < this.parts.size()) {
                List<String> exprPart;
                PrintPart part = this.parts.get(i);
                char del = part.delimiter;
                String add = null;
                Type type = part.term.getType();
                if (!part.part.replace("\"", "").isEmpty() && !(exprPart = compiler.compileToPseudoCode(config, machine, part.term)).isEmpty()) {
                    String expPush = this.getPushRegister(exprPart.get(exprPart.size() - 1));
                    exprPart = exprPart.subList(0, exprPart.size() - 1);
                    expr.addAll(exprPart);
                    if (expPush.equals("Y")) {
                        expr.add("MOV X,Y");
                    } else if (expPush.equals("B")) {
                        expr.add("MOV A,B");
                    }
                    String lastCmd = expr.get(expr.size() - 1);
                    if (this.isFileWrite(appendix)) {
                        expr = this.saveC(expr);
                    }
                    if (!lastCmd.startsWith("JSR TAB") && !lastCmd.startsWith("JSR SPC")) {
                        if (type.equals((Object)Type.INTEGER)) {
                            expr.add("JSR INTOUT" + appendix);
                        } else if (type.equals((Object)Type.REAL)) {
                            expr.add("JSR REALOUT" + appendix);
                        } else {
                            expr.add("JSR STROUT" + appendix);
                        }
                    }
                    if (this.isFileWrite(appendix)) {
                        expr.add("PUSH C");
                    }
                }
                if (del == ';' || del == ' ') {
                    if (type.equals((Object)Type.INTEGER) || type.equals((Object)Type.REAL)) {
                        add = this.isFileWrite(appendix) ? " " : "{right}";
                    }
                    if (del == ' ' && i == this.parts.size() - 1) {
                        add = "\n";
                    }
                } else if (del == ',') {
                    add = "\t";
                }
                if (this.isFileWrite(appendix)) {
                    expr = this.saveC(expr);
                }
                if ("\n".equals(add)) {
                    if (type.equals((Object)Type.INTEGER) || type.equals((Object)Type.REAL)) {
                        if (this.isFileWrite(appendix)) {
                            expr.add("MOV A,# {STRING}");
                            expr.add("JSR STROUT" + appendix);
                        } else {
                            expr.add("JSR CHECKCMD");
                        }
                    }
                    expr.add("JSR LINEBREAK" + appendix);
                } else if (add != null) {
                    if (add.equals("\t")) {
                        if (type.equals((Object)Type.INTEGER) || type.equals((Object)Type.REAL)) {
                            if (this.isFileWrite(appendix)) {
                                expr.add("JSR STROUT" + appendix);
                            } else {
                                expr.add("JSR CRSRRIGHT");
                            }
                        }
                        expr.add("JSR TABOUT" + appendix);
                    } else if (add.equals("{right}")) {
                        expr.add("JSR CRSRRIGHT");
                    } else {
                        expr.add("MOV A,#" + add + "{STRING}");
                        expr.add("JSR STROUT" + appendix);
                    }
                }
                if (this.isFileWrite(appendix) && i != this.parts.size() - 1) {
                    expr.add("PUSH C");
                }
                ++i;
            }
        }
        catch (CompilerException e) {
            throw new RuntimeException("Syntax error: " + this.orgLine);
        }
        if (expr.size() > 0 && ((String)expr.get(expr.size() - 1)).equals("PUSH C")) {
            expr = expr.subList(0, expr.size() - 1);
        }
        CodeContainer cc = new CodeContainer(before, expr, after);
        ArrayList<CodeContainer> ccs = new ArrayList<CodeContainer>();
        ccs.add(cc);
        return ccs;
    }

    private boolean isFileWrite(String appendix) {
        return !appendix.isEmpty();
    }

    /*
     * Unable to fully structure code
     */
    protected List<PrintPart> getParts(String line, CompilerConfig config) {
        line = TermEnhancer.removeWhiteSpace(line);
        res = new ArrayList<PrintPart>();
        inString = false;
        brackets = 0;
        sb = new StringBuilder();
        if (config.isNonDecimalNumbersAware()) {
            line = TermEnhancer.handleNonDecimalNumbers(config, line);
        }
        line = this.fixKludges(line);
        inString = false;
        i = 0;
        while (i < line.length()) {
            c = line.charAt(i);
            if (c == '\"') {
                v0 = inString = inString == false;
                if (inString && sb.length() > 0 && !(part = sb.toString()).endsWith("(") && part.length() > 0 && !Operator.isOperator(part.charAt(part.length() - 1))) {
                    sb.setLength(0);
                    pp = new PrintPart(part, ' ');
                    res.add(pp);
                }
            }
            if (inString && i == line.length() - 1) {
                inString = false;
            }
            if (inString) ** GOTO lbl-1000
            nc = ' ';
            booleanFollows = false;
            if (i < line.length() - 1) {
                nc = line.charAt(i + 1);
            }
            if (i < line.length() - 3) {
                ns = line.substring(i + 1, i + 4).toLowerCase(Locale.ENGLISH);
                v1 = booleanFollows = ns.equals("and") != false || ns.startsWith("or") != false;
            }
            if (c == '(') {
                ++brackets;
            }
            if (c == ')') {
                --brackets;
            }
            v2 = end = i == line.length() - 1;
            if ((end || brackets == 0 && (c == '\"' || c == ')' && nc != '=' && nc != '<' && nc != '>' && booleanFollows == false || c == ',' || c == ';' || c == '$' && nc != '(' || c == '%' && nc != '(')) && (end || !Operator.isRealOperator(nc) || c == ';' || c == ',')) {
                if (end || c == '\"' || c == ')' || c == '%' || c == '$') {
                    if (end) {
                        nc = ' ';
                    }
                    if (c != ',' && c != ';') {
                        nc = ' ';
                        sb.append(c);
                    } else {
                        nc = c;
                    }
                } else {
                    nc = c;
                }
                part = sb.toString();
                sb.setLength(0);
                if (part.length() == 0) {
                    part = "\"\"";
                }
                pp = new PrintPart(part, nc);
                res.add(pp);
                upart = VarUtils.toUpper(part);
                if (end && (upart.contains("SPC(") || upart.contains("TAB(")) && part.endsWith(")")) {
                    line = String.valueOf(line) + ";";
                }
            } else lbl-1000:
            // 2 sources

            {
                sb.append(c);
            }
            ++i;
        }
        return res;
    }

    private String fixKludges(String line) {
        boolean inString = false;
        boolean hadLetter = false;
        List<Function> funs = FunctionList.getFunctions();
        int i = 1;
        while (i < line.length()) {
            char c = line.charAt(i - 1);
            if (c == '\"') {
                boolean bl = inString = !inString;
            }
            if (!inString && (Character.isLetterOrDigit(c) || c == '.')) {
                hadLetter |= Character.isLetter(c);
                String sub = line.substring(i);
                String subSub = line.substring(i - 1);
                boolean splitted = false;
                boolean subSubOk = true;
                for (Function fun : funs) {
                    if (!fun.isFunction(subSub)) continue;
                    subSubOk = false;
                    break;
                }
                if (subSubOk) {
                    for (Function fun : funs) {
                        if (!fun.isFunction(sub)) continue;
                        line = String.valueOf(line.substring(0, i)) + ";" + line.substring(i);
                        i += fun.getName().length() + 1;
                        splitted = true;
                        hadLetter = false;
                        break;
                    }
                }
                if (!splitted) {
                    sub = sub.toLowerCase(Locale.ENGLISH);
                    char cn = line.charAt(i);
                    if ((Character.isDigit(c) || c == '.' || c == ')') && (!hadLetter && cn == '(' || Character.isLetter(cn) || c == '.' && cn == '.' || c == ')' && Character.isLetterOrDigit(cn)) && cn != 'e' && !sub.startsWith("and") && !sub.startsWith("or")) {
                        line = String.valueOf(line.substring(0, i)) + ";" + line.substring(i);
                        ++i;
                        hadLetter = false;
                    }
                }
            }
            ++i;
        }
        return line;
    }

    protected String clean(String txt) {
        return txt.replace("\n", "").replace("\r", "");
    }

    protected static class PrintPart {
        public String part;
        public char delimiter;
        public Term term;

        public PrintPart(String part, char delimiter) {
            this.part = part;
            this.delimiter = delimiter;
        }

        public String toString() {
            return String.valueOf(this.part) + "/" + this.delimiter + "/" + this.term;
        }
    }
}

