/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.commands;

import com.sixtyfour.cbmnative.NativeCompiler;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.commands.Print;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.BasicProgramCounter;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.ArrayList;
import java.util.List;

public class PrintFile
extends Print {
    private Atom fileNumber = null;

    public PrintFile() {
        super("PRINT#");
    }

    @Override
    public String parse(CompilerConfig config, String linePart, int lineCnt, int lineNumber, int linePos, boolean lastPos, Machine machine) {
        int pos = (linePart = linePart.substring(this.name.length())).indexOf(44);
        if (pos == -1) {
            pos = linePart.length();
        }
        this.term = Parser.getTerm(config, linePart.substring(0, pos), machine, false, true);
        linePart = pos != linePart.length() ? linePart.substring(pos + 1) : "";
        List<Atom> pars = Parser.getParameters(this.term);
        if (pars.size() != 1) {
            this.syntaxError(this);
        }
        this.fileNumber = pars.get(0);
        this.checkTypes(pars, linePart, Type.STRING);
        super.parse(config, "PRINT" + linePart, lineCnt, lineNumber, linePos, lastPos, machine);
        return null;
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        machine.setCurrentCommand(this);
        NativeCompiler compiler = NativeCompiler.getCompiler();
        ArrayList<String> after = new ArrayList<String>();
        List<String> expr = null;
        ArrayList<String> before = new ArrayList<String>();
        expr = compiler.compileToPseudoCode(config, machine, this.fileNumber);
        CodeContainer cc = new CodeContainer(before, expr, after);
        ArrayList<CodeContainer> ccs = new ArrayList<CodeContainer>();
        ccs.add(cc);
        ccs.addAll(this.evalToCode(config, machine, "CHANNEL"));
        machine.setCurrentCommand(null);
        return ccs;
    }

    @Override
    public BasicProgramCounter execute(CompilerConfig config, Machine machine) {
        int fn = VarUtils.getInt(this.fileNumber.eval(machine));
        if (machine.getOutputChannel().getChannel() == fn) {
            machine.getOutputChannel().setPrintConsumer(null, 0);
        }
        return this.execute(machine, machine.getDeviceProvider(), fn);
    }
}

