/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.commands;

import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.Variable;
import com.sixtyfour.elements.commands.MultiVariableCommand;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.parser.Term;
import com.sixtyfour.parser.TermEnhancer;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.BasicProgramCounter;
import com.sixtyfour.system.DataStore;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.List;

public class Read
extends MultiVariableCommand {
    public Read() {
        super("READ");
    }

    @Override
    public Type getType() {
        return Type.NONE;
    }

    @Override
    public String parse(CompilerConfig config, String linePart, int lineCnt, int lineNumber, int linePos, boolean lastPos, Machine machine) {
        super.parse(config, linePart, lineCnt, lineNumber, linePos, lastPos, machine);
        linePart = TermEnhancer.removeWhiteSpace(linePart);
        linePart = linePart.substring(4).trim();
        if (linePart.length() == 0) {
            this.syntaxError(this);
        }
        this.fillVariables(config, linePart, machine);
        return null;
    }

    @Override
    public BasicProgramCounter execute(CompilerConfig config, Machine machine) {
        DataStore data = machine.getDataStore();
        int i = 0;
        while (i < this.vars.size()) {
            Term indexTerm = (Term)this.indexTerms.get(i);
            Variable var = this.getVariable(machine, i);
            Object obj = data.read();
            Type varType = var.getType();
            if (obj == null) {
                throw new RuntimeException("Out of data error: " + this);
            }
            if (obj.toString().equals("\\0")) {
                obj = varType.equals((Object)Type.STRING) ? "" : (varType.equals((Object)Type.REAL) ? (Number)Float.valueOf(0.0f) : (Number)0);
            }
            if (obj.toString().equals(".")) {
                obj = varType.equals((Object)Type.STRING) ? "." : (varType.equals((Object)Type.REAL) ? (Number)Float.valueOf(0.0f) : (Number)0);
            }
            if (indexTerm != null) {
                List<Atom> pars = Parser.getParameters(indexTerm);
                int[] pis = new int[pars.size()];
                int cnt = 0;
                for (Atom par : pars) {
                    pis[cnt++] = VarUtils.getInt(par.eval(machine));
                }
                if (varType.equals((Object)Type.STRING)) {
                    var.setValue(obj.toString(), pis);
                } else if (varType.equals((Object)Type.REAL)) {
                    if (VarUtils.isNumber(obj)) {
                        var.setValue(Float.valueOf(VarUtils.getFloat(obj)), pis);
                    } else {
                        this.typeMismatchRead(obj);
                    }
                } else if (varType.equals((Object)Type.INTEGER)) {
                    if (VarUtils.isInteger(obj)) {
                        var.setValue(VarUtils.getInt(obj), pis);
                    } else {
                        this.typeMismatchRead(obj);
                    }
                }
            } else if (varType.equals((Object)Type.STRING)) {
                var.setValue(obj.toString());
            } else if (varType.equals((Object)Type.REAL)) {
                if (VarUtils.isNumber(obj)) {
                    var.setValue(Float.valueOf(VarUtils.getFloat(obj)));
                } else {
                    this.typeMismatchRead(obj);
                }
            } else if (varType.equals((Object)Type.INTEGER)) {
                if (VarUtils.isInteger(obj)) {
                    var.setValue(VarUtils.getInt(obj));
                } else {
                    this.typeMismatchRead(obj);
                }
            }
            ++i;
        }
        return null;
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        return this.evalToCode(config, machine, "READSTR", "READNUMBER");
    }

    private void typeMismatchRead(Object obj) {
        throw new RuntimeException("Type mismatch error: " + this + "/" + obj);
    }
}

