/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.commands;

import com.sixtyfour.cbmnative.Util;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.commands.AbstractCommand;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.BasicProgramCounter;
import com.sixtyfour.system.Machine;
import com.sixtyfour.system.StackEntry;
import java.util.List;

public class Return
extends AbstractCommand {
    private BasicProgramCounter pc = new BasicProgramCounter(0, 0);

    public Return() {
        super("RETURN");
    }

    @Override
    public String parse(CompilerConfig config, String linePart, int lineCnt, int lineNumber, int linePos, boolean lastPos, Machine machine) {
        super.parse(config, linePart, lineCnt, lineNumber, linePos, lastPos, machine);
        linePart = linePart.substring(6).trim();
        if (linePart.trim().length() > 0) {
            this.syntaxError(this);
        }
        return null;
    }

    @Override
    public BasicProgramCounter execute(CompilerConfig config, Machine machine) {
        StackEntry caller = machine.getCaller();
        if (caller == null) {
            throw new RuntimeException("RETURN without GOSUB error!");
        }
        AbstractCommand gosub = (AbstractCommand)caller.getCommand();
        this.pc.setLineCnt(gosub.lineCnt);
        this.pc.setLinePos(gosub.linePos);
        return this.pc;
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        return Util.createSingleCommand("JSR RETURN", "RTS");
    }
}

