/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.commands;

import com.sixtyfour.cbmnative.Util;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.commands.AbstractCommand;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.BasicProgramCounter;
import com.sixtyfour.system.Machine;
import java.util.List;

public class Run
extends AbstractCommand {
    private BasicProgramCounter pc = new BasicProgramCounter(0, 0);
    private int targetLineNumber = -1;

    public Run() {
        super("RUN");
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        return Util.createSingleCommand("JSR RUN");
    }

    @Override
    public String parse(CompilerConfig config, String linePart, int lineCnt, int lineNumber, int linePos, boolean lastPos, Machine machine) {
        super.parse(config, linePart, lineCnt, lineNumber, linePos, lastPos, machine);
        linePart = linePart.substring(3).trim();
        if (linePart.trim().length() > 0) {
            try {
                this.targetLineNumber = Integer.parseInt(linePart);
            }
            catch (Exception e) {
                throw new RuntimeException("Undef'd statement error: " + this);
            }
        }
        return null;
    }

    @Override
    public BasicProgramCounter execute(CompilerConfig config, Machine machine) {
        machine.resetMemory();
        machine.getDataStore().restore();
        this.pc.setLinePos(-1);
        if (this.targetLineNumber != -1) {
            this.pc.setLineNumber(this.targetLineNumber);
        } else {
            this.pc.setLineNumber(-1);
            this.pc.setLineCnt(0);
        }
        return this.pc;
    }
}

