/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.commands;

import com.sixtyfour.cbmnative.NativeCompiler;
import com.sixtyfour.cbmnative.Util;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.commands.AbstractCommand;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.BasicProgramCounter;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.ArrayList;
import java.util.List;

public class Sys
extends AbstractCommand {
    private Atom addr;
    private List<Atom> vals;

    public Sys() {
        super("SYS");
    }

    @Override
    public String parse(CompilerConfig config, String linePart, int lineCnt, int lineNumber, int linePos, boolean lastPos, Machine machine) {
        super.parse(config, linePart, lineCnt, lineNumber, linePos, lastPos, machine);
        this.term = Parser.getTerm(config, this, linePart, machine, true);
        List<Atom> pars = Parser.getParameters(this.term);
        if (pars.isEmpty()) {
            this.syntaxError(linePart);
        }
        this.checkTypes(pars, linePart, Type.STRING);
        this.addr = pars.get(0);
        this.vals = pars.subList(1, pars.size());
        return null;
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        List<Atom> pars = Parser.getParameters(this.term);
        if (pars.size() > 1) {
            return this.createMultiParsCall(config, machine);
        }
        if (this.addr.isConstant()) {
            int memAddr = VarUtils.getInt(this.addr.eval(machine));
            if (memAddr < 0 || memAddr > 65535) {
                throw new RuntimeException("Illegal quantity error: " + this);
            }
            return Util.createSingleCommand("JSR $" + Integer.toHexString(memAddr));
        }
        return this.createSingleParameterCall(config, machine, pars, "SYSTEMCALLDYN");
    }

    @Override
    protected List<String> addSingleParameter(CompilerConfig config, Machine machine, NativeCompiler compiler, List<Atom> pars) {
        List<String> expr = compiler.compileToPseudoCode(config, machine, pars.get(0));
        String expPush = this.getPushRegister(expr.get(expr.size() - 1));
        expr = expr.subList(0, expr.size() - 1);
        if (expPush.equals("Y")) {
            expr.add("MOV X,Y");
        } else if (expPush.equals("A")) {
            expr.add("MOV B,A");
        }
        return expr;
    }

    @Override
    public BasicProgramCounter execute(CompilerConfig config, Machine machine) {
        int memAddr = VarUtils.getInt(this.addr.eval(machine));
        if (memAddr < 0 || memAddr > 65535) {
            throw new RuntimeException("Illegal quantity error: " + this);
        }
        Object[] params = null;
        if (!this.vals.isEmpty()) {
            params = new Object[this.vals.size()];
            int cnt = 0;
            for (Atom val : this.vals) {
                params[cnt++] = val.eval(machine);
            }
        }
        machine.getSystemCallListener().sys(memAddr, params);
        return null;
    }

    private List<CodeContainer> createMultiParsCall(CompilerConfig config, Machine machine) {
        NativeCompiler compiler = NativeCompiler.getCompiler();
        ArrayList<String> after = new ArrayList<String>();
        List<Object> expr = new ArrayList();
        ArrayList<String> before = new ArrayList<String>();
        before.add("JSR SETUPMULTIPARS");
        List<Atom> pars = Parser.getParameters(this.term);
        int i = 1;
        while (i < pars.size()) {
            List<Atom> par = pars.subList(i, i + 1);
            List<String> part = this.addSingleParameter(config, machine, compiler, par);
            if (par.get(0).getType(true) == Type.STRING) {
                part.add("JSR COPYSTRINGPAR");
            } else {
                part.add("JSR COPYREALPAR");
            }
            before.addAll(part);
            ++i;
        }
        before.add("JSR ADDCOLON");
        after.add("JSR PULLDOWNMULTIPARS");
        if (this.addr.isConstant()) {
            int memAddr = VarUtils.getInt(this.addr.eval(machine));
            if (memAddr < 0 || memAddr > 65535) {
                throw new RuntimeException("Illegal quantity error: " + this);
            }
            expr.add("JSR $" + Integer.toHexString(memAddr));
        } else {
            expr = this.addSingleParameter(config, machine, compiler, pars);
            expr.add("JSR SYSTEMCALLDYN");
        }
        CodeContainer cc = new CodeContainer(before, expr, after);
        ArrayList<CodeContainer> ccs = new ArrayList<CodeContainer>();
        ccs.add(cc);
        return ccs;
    }
}

