/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.commands;

import com.sixtyfour.cbmnative.NativeCompiler;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.commands.AbstractCommand;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.BasicProgramCounter;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.ArrayList;
import java.util.List;

public class Wait
extends AbstractCommand {
    private static int waitCount = 0;
    private boolean stop = false;

    public Wait() {
        super("WAIT");
    }

    @Override
    public String parse(CompilerConfig config, String linePart, int lineCnt, int lineNumber, int linePos, boolean lastPos, Machine machine) {
        super.parse(config, linePart, lineCnt, lineNumber, linePos, lastPos, machine);
        this.term = Parser.getTerm(config, this, linePart, machine, true);
        List<Atom> pars = Parser.getParameters(this.term);
        if (pars.size() < 2 || pars.size() > 3) {
            this.syntaxError(linePart);
        }
        this.checkTypes(pars, linePart, Type.STRING, Type.STRING, Type.STRING);
        return null;
    }

    @Override
    public void stopExecution() {
        this.stop = true;
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        List<Atom> pars = Parser.getParameters(this.term);
        pars = Parser.getParameters(this.term);
        Atom addr = pars.get(0);
        Atom waitFor = pars.get(1);
        System.out.println("Tr\u00f6t: " + addr + "/" + waitFor);
        NativeCompiler compiler = NativeCompiler.getCompiler();
        ArrayList<String> after = new ArrayList<String>();
        List<String> expr = new ArrayList<String>();
        int wc = waitCount++;
        String label = "WAIT" + wc;
        boolean invertFound = false;
        if (pars.size() == 3) {
            invertFound = true;
            Atom inverted = pars.get(2);
            expr.addAll(compiler.compileToPseudoCode(config, machine, inverted));
        }
        expr.addAll(compiler.compileToPseudoCode(config, machine, waitFor));
        List<String> before = null;
        String expPush = this.getPushRegister((String)expr.get(expr.size() - 1));
        expr = expr.subList(0, expr.size() - 1);
        before = compiler.compileToPseudoCode(config, machine, addr);
        if (expPush.equals("Y")) {
            expr.add("MOV X,Y");
        }
        if (invertFound) {
            after.add("POP C");
        }
        after.add("POP Y");
        after.add(String.valueOf(label) + ":");
        after.add("MOV D,(Y)");
        if (invertFound) {
            after.add("XOR D,C");
        }
        after.add("AND D,X");
        after.add("CMP D,#0{INTEGER}");
        after.add("JE " + label);
        CodeContainer cc = new CodeContainer(before, expr, after);
        ArrayList<CodeContainer> ccs = new ArrayList<CodeContainer>();
        ccs.add(cc);
        return ccs;
    }

    @Override
    public BasicProgramCounter execute(CompilerConfig config, Machine machine) {
        List<Atom> pars = Parser.getParameters(this.term);
        Atom addr = pars.get(0);
        Atom waitFor = pars.get(1);
        int memAddr = VarUtils.getInt(addr.eval(machine));
        int vally = VarUtils.getInt(waitFor.eval(machine));
        if (vally < 0 || vally > 255 || memAddr < 0 || memAddr > 65535) {
            throw new RuntimeException("Illegal quantity error: " + this);
        }
        int invert = 0;
        boolean invertFound = false;
        if (pars.size() == 3) {
            invertFound = true;
            Atom inverted = pars.get(2);
            invert = VarUtils.getInt(inverted.eval(machine));
            if (invert < 0 || invert > 255) {
                throw new RuntimeException("Illegal quantity error: " + this);
            }
        }
        if (!invertFound && memAddr == 6502 && vally == 1) {
            machine.getOutputChannel().systemPrintln(0, "EgonOlsen!");
        }
        while (machine.getMemoryListener().wait(memAddr, vally, invert) && !this.stop) {
            Thread.yield();
        }
        this.stop = false;
        return null;
    }
}

