/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.commands.internal;

import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.commands.AbstractCommand;
import com.sixtyfour.elements.commands.For;
import com.sixtyfour.elements.commands.Let;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.BasicProgramCounter;
import com.sixtyfour.system.Machine;
import java.util.List;

public class Delay
extends AbstractCommand {
    private static final float MS_PER_STEP = 1.2f;
    private For delayLoop;
    private boolean delay;

    public Delay(For delayLoop, boolean delay) {
        super("__DELAY");
        this.delayLoop = delayLoop;
        this.delay = delay;
    }

    @Override
    public BasicProgramCounter execute(CompilerConfig config, Machine machine) {
        this.delayLoop.setToFinalValue(machine);
        if (this.delay) {
            long steps = this.delayLoop.getSteps(machine);
            long waitTime = (long)((float)steps * 1.2f);
            try {
                Thread.sleep(waitTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        Let letty = new Let();
        letty.setTerm(this.delayLoop.getEndTerm());
        letty.setVar(this.delayLoop.getVar());
        return letty.evalToCode(config, machine);
    }
}

