/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.functions;

import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.functions.AbstractFunction;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;

public class Abs
extends AbstractFunction {
    public Abs() {
        super("ABS");
    }

    @Override
    public Type getType() {
        return this.term.getType();
    }

    @Override
    public Type getParameterType() {
        return Type.REAL;
    }

    @Override
    public Object eval(Machine machine) {
        if (!this.term.getType().equals((Object)Type.STRING)) {
            float val = Math.abs(VarUtils.getFloat(this.term.eval(machine)));
            if (this.term.getType().equals((Object)Type.REAL)) {
                return Float.valueOf(val);
            }
            return (int)val;
        }
        throw new RuntimeException("Formula too complex error: " + this);
    }

    @Override
    public String toCode(Machine machine) {
        String inter = this.term.toCode(machine);
        if (inter == null) {
            return null;
        }
        return String.valueOf(this.term.getType().equals((Object)Type.REAL) ? "(float)" : "(int)") + "Math.abs(" + inter + ")";
    }

    @Override
    public int getParameterCount() {
        return 1;
    }
}

