/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.functions;

import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.functions.Function;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.parser.Term;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public abstract class AbstractFunction
implements Function {
    protected String name;
    protected Term term;
    protected String functionName;

    @Override
    public Type getType(boolean ignoreMt) {
        return this.getType();
    }

    public AbstractFunction(String name) {
        this.name = VarUtils.toUpper(name);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Function && this.isDeterministic()) {
            if (o == this) {
                return true;
            }
            return this.name.equals(((Function)o).getName()) && this.term.equals(((Function)o).getTerm());
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    protected void typeMismatch(String line) {
        throw new RuntimeException("Type mismatch error: " + line);
    }

    protected void syntaxError(String line) {
        throw new RuntimeException("Syntax error: " + line);
    }

    protected void typeMismatch(Object obj) {
        this.typeMismatch(obj.toString());
    }

    protected void syntaxError(Object obj) {
        this.syntaxError(obj.toString());
    }

    @Override
    public int getParameterCount() {
        return 0;
    }

    @Override
    public Function clone() {
        try {
            AbstractFunction clone = (AbstractFunction)this.getClass().newInstance();
            clone.name = this.name;
            return clone;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate function: " + this.name);
        }
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("_");
        List<String> n1 = this.term.evalToCode(config, machine).get(0).getExpression();
        n1.add(":" + this.getNativeFunctionName());
        ret.addAll(0, n1);
        ArrayList<CodeContainer> cc = new ArrayList<CodeContainer>();
        cc.add(new CodeContainer(ret));
        return cc;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Term getTerm() {
        return this.term;
    }

    @Override
    public String getInitialCall() {
        return String.valueOf(this.name) + "(" + this.term.getInitial() + ")";
    }

    @Override
    public void setTerm(Term term) {
        this.term = term;
    }

    @Override
    public void parse(CompilerConfig config, String linePart, Machine machine) {
        this.setTerm(Parser.getTerm(config, linePart, machine, false, true));
        if (this.getParameterCount() > 0 && Parser.getParameters(this.term).size() > this.getParameterCount()) {
            throw new RuntimeException("Syntax error: " + linePart);
        }
    }

    @Override
    public boolean typesMatch() {
        Atom par;
        Type type = this.getParameterType();
        return type == null || this.getParameterCount() != 1 || ((par = Parser.getParameters(this.term).get(0)).getType(true) != Type.STRING || type == Type.STRING) && (par.getType(true) == Type.STRING || type != Type.STRING);
    }

    @Override
    public boolean isFunction(String function) {
        return VarUtils.toUpper(function.trim()).startsWith(this.name);
    }

    @Override
    public boolean isNativeFunction(String function) {
        return VarUtils.toUpper(function.trim()).startsWith(this.getNativeFunctionName());
    }

    @Override
    public boolean hasPostfix() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public boolean isExcluded() {
        return false;
    }

    @Override
    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String toString() {
        return String.valueOf(this.name) + "(" + this.term + ")";
    }

    @Override
    public boolean isTerm() {
        return false;
    }

    @Override
    public String toCode(Machine machine) {
        return null;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isOverride() {
        return false;
    }

    @Override
    public String getNativeFunctionName() {
        return this.getClass().getSimpleName().toUpperCase(Locale.ENGLISH);
    }

    @Override
    public boolean addNativeFunctionCall(List<String> code) {
        return false;
    }

    @Override
    public Type getParameterType() {
        return null;
    }
}

