/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.functions;

import com.sixtyfour.Logger;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.Variable;
import com.sixtyfour.elements.functions.AbstractFunction;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.parser.Term;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.ArrayList;
import java.util.List;

public class ArrayAccess
extends AbstractFunction {
    private String variableName;
    private Type variableType;
    private int[] pis;

    public ArrayAccess() {
        super("[]");
    }

    @Override
    public Type getType() {
        return this.variableType;
    }

    @Override
    public Object eval(Machine machine) {
        this.fillParameterIndices(machine);
        Variable vary = machine.getVariableUpperCase(this.variableName);
        if (vary == null) {
            if (this.variableType.equals((Object)Type.REAL)) {
                return Float.valueOf(0.0f);
            }
            if (this.variableType.equals((Object)Type.INTEGER)) {
                return 0;
            }
            if (this.variableType.equals((Object)Type.STRING)) {
                return "";
            }
            return null;
        }
        return vary.getValue(this.pis);
    }

    @Override
    public boolean typesMatch() {
        List<Atom> pars = Parser.getParameters(this.term);
        for (Atom par : pars) {
            if (par.getType(true) != Type.STRING) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("_");
        Variable vary = machine.getVariableUpperCase(this.variableName);
        if (vary == null) {
            Variable tmpVar = new Variable(this.variableName, null, 10);
            machine.add(tmpVar);
            Logger.log("Array not defined: " + this.variableName + ", defaulting to 10!");
            vary = machine.getVariableUpperCase(this.variableName);
        }
        List<Atom> pars = Parser.getParameters(this.term);
        int[] dimensions = vary.getDimensions();
        if (pars.size() != dimensions.length) {
            throw new RuntimeException("Array indices don't match (" + this.variableName + "): " + this + "/" + pars.size() + "/" + dimensions.length);
        }
        Term t = Parser.createIndexTerm(config, machine, pars, dimensions);
        List<String> n1 = t.evalToCode(config, machine).get(0).getExpression();
        n1.addAll(vary.evalToCode(config, machine).get(0).getExpression());
        n1.add(":" + this.getNativeFunctionName());
        ret.addAll(0, n1);
        ArrayList<CodeContainer> cc = new ArrayList<CodeContainer>();
        cc.add(new CodeContainer(ret));
        return cc;
    }

    public void setVariable(Variable variable) {
        this.variableType = variable.getType();
        this.variableName = VarUtils.toUpper(variable.getName());
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    @Override
    public String getInitialCall() {
        return String.valueOf(this.variableName.replace("[]", "")) + "(" + this.term.getInitial() + ")";
    }

    private void fillParameterIndices(Machine machine) {
        List<Atom> pars = Parser.getParameters(this.term);
        if (this.pis == null) {
            this.pis = new int[pars.size()];
        }
        int i = 0;
        while (i < pars.size()) {
            this.pis[i] = VarUtils.getInt(pars.get(i).eval(machine));
            ++i;
        }
    }
}

