/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.functions;

import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.Variable;
import com.sixtyfour.elements.commands.Def;
import com.sixtyfour.elements.functions.AbstractFunction;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.ArrayList;
import java.util.List;

public class Fn
extends AbstractFunction {
    public Fn() {
        super("FN");
    }

    @Override
    public Type getType() {
        return Type.REAL;
    }

    @Override
    public Object eval(Machine machine) {
        Def def = (Def)machine.getFunction(this.functionName);
        if (def == null) {
            throw new RuntimeException("Undef'd function error: " + this + "/" + this.functionName);
        }
        if (this.term.getType().equals((Object)Type.STRING)) {
            this.typeMismatch(this);
        }
        Object val = this.term.eval(machine);
        Variable placeHolder = machine.getVariable(def.getVarName());
        placeHolder.setValue(Float.valueOf(VarUtils.getFloat(val)));
        return def.eval(machine);
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        Def def = (Def)machine.getFunction(this.functionName);
        if (def == null) {
            throw new RuntimeException("Undef'd function error: " + this + "/" + this.functionName);
        }
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("_");
        List<String> n1 = this.term.evalToCode(config, machine).get(0).getExpression();
        n1.add(":" + this.getNativeFunctionName() + " DEF" + def.getCount());
        ret.addAll(0, n1);
        ArrayList<CodeContainer> ccs = new ArrayList<CodeContainer>();
        ccs.add(new CodeContainer(ret));
        return ccs;
    }

    @Override
    public boolean hasPostfix() {
        return true;
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    @Override
    public int getParameterCount() {
        return 1;
    }
}

