/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.functions;

import com.sixtyfour.elements.functions.Abs;
import com.sixtyfour.elements.functions.Asc;
import com.sixtyfour.elements.functions.Atn;
import com.sixtyfour.elements.functions.Chr;
import com.sixtyfour.elements.functions.Cos;
import com.sixtyfour.elements.functions.Exp;
import com.sixtyfour.elements.functions.Fn;
import com.sixtyfour.elements.functions.Fre;
import com.sixtyfour.elements.functions.Function;
import com.sixtyfour.elements.functions.Int;
import com.sixtyfour.elements.functions.Left;
import com.sixtyfour.elements.functions.Len;
import com.sixtyfour.elements.functions.Log;
import com.sixtyfour.elements.functions.Mid;
import com.sixtyfour.elements.functions.Peek;
import com.sixtyfour.elements.functions.Pos;
import com.sixtyfour.elements.functions.Right;
import com.sixtyfour.elements.functions.Rnd;
import com.sixtyfour.elements.functions.Sgn;
import com.sixtyfour.elements.functions.Sin;
import com.sixtyfour.elements.functions.Spc;
import com.sixtyfour.elements.functions.Sqr;
import com.sixtyfour.elements.functions.Str;
import com.sixtyfour.elements.functions.Tab;
import com.sixtyfour.elements.functions.Tan;
import com.sixtyfour.elements.functions.Usr;
import com.sixtyfour.elements.functions.Val;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class FunctionList {
    private static List<Function> FUNCTIONS = Collections.unmodifiableList(new ArrayList<Function>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(new Sin());
            this.add(new Cos());
            this.add(new Peek());
            this.add(new Mid());
            this.add(new Spc());
            this.add(new Tab());
            this.add(new Pos());
            this.add(new Int());
            this.add(new Fre());
            this.add(new Rnd());
            this.add(new Usr());
            this.add(new Abs());
            this.add(new Atn());
            this.add(new Exp());
            this.add(new Log());
            this.add(new Sgn());
            this.add(new Sqr());
            this.add(new Tan());
            this.add(new Len());
            this.add(new Asc());
            this.add(new Val());
            this.add(new Chr());
            this.add(new Str());
            this.add(new Left());
            this.add(new Right());
            this.add(new Fn());
        }
    });

    public static void registerNewFunctions(List<Function> functions) {
        if (functions != null && !functions.isEmpty()) {
            FUNCTIONS = new ArrayList<Function>(FUNCTIONS);
            Set newNames = functions.stream().filter(p -> p.isOverride()).map(p -> p.getName()).collect(Collectors.toSet());
            FUNCTIONS = FUNCTIONS.stream().filter(p -> !newNames.contains(p.getName())).collect(Collectors.toList());
            FUNCTIONS.addAll(functions);
            FUNCTIONS = Collections.unmodifiableList(FUNCTIONS);
            ArrayList<String> names = new ArrayList<String>();
            for (Function command : FUNCTIONS) {
                for (String name : names) {
                    if (!command.getName().startsWith(name)) continue;
                    throw new RuntimeException("Naming conflict: " + command.getName() + " is hidden by " + name);
                }
                names.add(command.getName());
            }
        }
    }

    public static List<Function> getFunctions() {
        return FUNCTIONS;
    }
}

