/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.functions;

import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.functions.AbstractFunction;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;

public class Int
extends AbstractFunction {
    public Int() {
        super("INT");
    }

    @Override
    public Type getType() {
        return Type.INTEGER;
    }

    @Override
    public Type getParameterType() {
        return Type.REAL;
    }

    @Override
    public Object eval(Machine machine) {
        if (this.term.getType().equals((Object)Type.STRING)) {
            this.typeMismatch((Object)this.term.getType());
        }
        Number num = (Number)this.term.eval(machine);
        int val = VarUtils.getInt(num);
        if (num.floatValue() < 0.0f && num.floatValue() != (float)val) {
            --val;
        }
        return val;
    }

    @Override
    public String toCode(Machine machine) {
        String inter = this.term.toCode(machine);
        if (inter == null) {
            return null;
        }
        return "(int) (" + inter + ")";
    }

    @Override
    public int getParameterCount() {
        return 1;
    }
}

