/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.functions;

import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.functions.AbstractFunction;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.ArrayList;
import java.util.List;

public class Mid
extends AbstractFunction {
    public Mid() {
        super("MID$");
    }

    @Override
    public Type getType() {
        return Type.STRING;
    }

    @Override
    public boolean typesMatch() {
        List<Atom> pars = Parser.getParameters(this.term);
        int cnt = 0;
        for (Atom par : pars) {
            if (par.getType(true) == Type.STRING && cnt > 0 || par.getType(true) != Type.STRING && cnt == 0) {
                return false;
            }
            ++cnt;
        }
        return true;
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        List<Atom> pars = Parser.getParameters(this.term);
        this.checkParameters(pars);
        Atom var = pars.get(0);
        ArrayList<String> ret = new ArrayList<String>();
        List<String> n1 = pars.get(1).evalToCode(config, machine).get(0).getExpression();
        n1.add(":PAR");
        n1.add("_");
        if (pars.size() > 2) {
            n1.addAll(pars.get(2).evalToCode(config, machine).get(0).getExpression());
        } else {
            n1.add("#-1{INTEGER}");
        }
        n1.add(":PAR");
        n1.add("_");
        n1.addAll(var.evalToCode(config, machine).get(0).getExpression());
        n1.add(":" + this.getNativeFunctionName());
        ret.addAll(0, n1);
        ret.add("_");
        ArrayList<CodeContainer> cc = new ArrayList<CodeContainer>();
        cc.add(new CodeContainer(ret));
        return cc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object eval(Machine machine) {
        try {
            List<Atom> pars = Parser.getParameters(this.term);
            this.checkParameters(pars);
            Atom var = pars.get(0);
            int start = VarUtils.getInt(pars.get(1).eval(machine)) - 1;
            int end = -999;
            if (pars.size() > 2) {
                end = VarUtils.getInt(pars.get(2).eval(machine)) + start;
            }
            String txt = var.eval(machine).toString();
            if (end == -999) {
                end = txt.length();
            }
            end = Math.min(end, txt.length());
            try {
                if (start >= txt.length()) {
                    return "";
                }
                return txt.substring(start, end);
            }
            catch (Exception e) {
                throw new RuntimeException("Illegal quantity error: " + txt + "/" + start);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException("Syntax error: " + this.term);
        }
    }

    private void checkParameters(List<Atom> pars) {
        if (pars.size() != 2 && pars.size() != 3) {
            throw new RuntimeException("Wrong number of parameters: " + this.term);
        }
    }
}

