/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.functions;

import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.commands.Print;
import com.sixtyfour.elements.commands.PrintFile;
import com.sixtyfour.elements.functions.AbstractFunction;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.ArrayList;
import java.util.List;

public class Spc
extends AbstractFunction {
    protected static final String SPACES;
    private static boolean limitedToPrint;

    static {
        limitedToPrint = true;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < 255) {
            sb.append(' ');
            ++i;
        }
        SPACES = sb.toString();
    }

    protected Spc(String name) {
        super(name);
    }

    public Spc() {
        super("SPC");
    }

    public static void setLimitedToPrint(boolean limited) {
        limitedToPrint = limited;
    }

    @Override
    public Type getType() {
        return Type.STRING;
    }

    @Override
    public Type getParameterType() {
        return Type.REAL;
    }

    @Override
    public Object eval(Machine machine) {
        int num;
        this.ensureContext(machine);
        if (this.term.getType().equals((Object)Type.STRING)) {
            this.typeMismatch(this);
        }
        if ((num = VarUtils.getInt(this.term.eval(machine))) < 0 || num > 255) {
            throw new RuntimeException("Illegal quantity error: " + this);
        }
        return SPACES.substring(0, num);
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("_");
        List<String> n1 = this.term.evalToCode(config, machine).get(0).getExpression();
        String call = ":" + this.getNativeFunctionName();
        if (machine.getCurrentCommand() instanceof PrintFile) {
            call = String.valueOf(call) + "CHANNEL";
        }
        n1.add(call);
        ret.addAll(0, n1);
        ArrayList<CodeContainer> cc = new ArrayList<CodeContainer>();
        cc.add(new CodeContainer(ret));
        return cc;
    }

    protected void ensureContext(Machine machine) {
        if (!(!limitedToPrint || machine.getCurrentCommand() instanceof Print && machine.getCurrentOperator().isNop())) {
            throw new RuntimeException("Syntax error: " + this);
        }
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    @Override
    public int getParameterCount() {
        return 1;
    }
}

