/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.mnemonics;

import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.mnemonics.Mnemonic;
import com.sixtyfour.parser.TermEnhancer;
import com.sixtyfour.parser.assembly.AssemblyParser;
import com.sixtyfour.parser.assembly.ConstantsContainer;
import com.sixtyfour.parser.assembly.LabelsContainer;
import com.sixtyfour.parser.assembly.Parameters;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;

public abstract class AbstractMnemonic
implements Mnemonic {
    private String name;
    protected int[] opcodes = null;

    public AbstractMnemonic(String name, int[] opcodes) {
        this.name = name;
        this.opcodes = opcodes;
        if (opcodes.length != 12) {
            throw new RuntimeException("Invalid opcode list: " + opcodes.length);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int parse(CompilerConfig config, String linePart, int addr, Machine machine, ConstantsContainer ccon, LabelsContainer lcon) {
        if (addr > 65535) {
            throw new RuntimeException("Compiled code exceeds 64K memory limit!");
        }
        linePart = linePart.trim().substring(3);
        Parameters pars = this.parseParameters(config, linePart, addr, ccon, lcon);
        if (this.opcodes[0] == 0 && pars == null) {
            this.raiseSyntaxError(linePart);
        }
        if (this.opcodes[0] != 0 && pars != null && this.isSingle()) {
            this.raiseSyntaxError(linePart);
        }
        if (this.opcodes[0] != 0 && pars != null && !this.isSingle() && this.getOptionalParameter() != null && this.getOptionalParameter().equalsIgnoreCase(pars.getRegister())) {
            pars = null;
        }
        int[] ram = machine.getRam();
        if (pars == null) {
            return this.store(ram, this.opcodes[0], addr);
        }
        if (pars.getValue() != null) {
            return this.storeByte(ram, this.opcodes[1], pars.getValue(), addr);
        }
        if (!pars.isIndirect()) {
            if (pars.isX()) {
                if (!pars.isZeropage()) return this.store(ram, this.opcodes[3], pars.getAddr(), addr);
                if (this.opcodes[6] == 0) return this.store(ram, this.opcodes[3], pars.getAddr(), addr);
                return this.storeByte(ram, this.opcodes[6], pars.getAddr(), addr);
            }
            if (pars.isY()) {
                if (!pars.isZeropage()) return this.store(ram, this.opcodes[4], pars.getAddr(), addr);
                if (this.opcodes[7] == 0) return this.store(ram, this.opcodes[4], pars.getAddr(), addr);
                return this.storeByte(ram, this.opcodes[7], pars.getAddr(), addr);
            }
            if (pars.isZeropage() && this.opcodes[5] != 0) {
                return this.storeByte(ram, this.opcodes[5], pars.getAddr(), addr);
            }
            if (!this.isRelative()) {
                return this.store(ram, this.opcodes[2], pars.getAddr(), addr);
            }
            int offset = pars.getAddr() - (addr + 2);
            if (offset > 127) throw new RuntimeException("Destination address out of range: " + pars.getAddr() + "/" + addr + "/" + offset);
            if (offset < -128) throw new RuntimeException("Destination address out of range: " + pars.getAddr() + "/" + addr + "/" + offset);
            return this.storeByte(ram, this.opcodes[11], offset, addr);
        }
        if (!pars.isZeropage() && (pars.isX() || pars.isY())) {
            this.raiseAddrError(linePart);
        }
        if (pars.isX()) {
            return this.storeByte(ram, this.opcodes[9], pars.getAddr(), addr);
        }
        if (!pars.isY()) return this.store(ram, this.opcodes[8], pars.getAddr(), addr);
        return this.storeByte(ram, this.opcodes[10], pars.getAddr(), addr);
    }

    @Override
    public String getOptionalParameter() {
        return null;
    }

    @Override
    public boolean isMnemonic(String linePart) {
        char c;
        boolean mne = VarUtils.toUpper(linePart.trim()).startsWith(this.name);
        if (mne && linePart.length() > this.name.length() && Character.isLetter(c = linePart.charAt(this.name.length()))) {
            return false;
        }
        return mne;
    }

    public AbstractMnemonic clone() {
        try {
            AbstractMnemonic clone = (AbstractMnemonic)this.getClass().newInstance();
            clone.name = this.name;
            return clone;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate mnemonic: " + this.name);
        }
    }

    @Override
    public boolean isRelative() {
        return false;
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public boolean isJump() {
        return false;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getInstruction(int opcode) {
        int cnt = 0;
        int[] nArray = this.opcodes;
        int n = this.opcodes.length;
        int n2 = 0;
        while (n2 < n) {
            int oc = nArray[n2];
            if (oc == opcode) {
                switch (cnt) {
                    case 0: {
                        return this.name;
                    }
                    case 1: {
                        return String.valueOf(this.name) + " #$nn";
                    }
                    case 2: {
                        return String.valueOf(this.name) + " $hhll";
                    }
                    case 3: {
                        return String.valueOf(this.name) + " $hhll, X";
                    }
                    case 4: {
                        return String.valueOf(this.name) + " $hhll, Y";
                    }
                    case 5: {
                        return String.valueOf(this.name) + " $ll";
                    }
                    case 6: {
                        return String.valueOf(this.name) + " $ll, X";
                    }
                    case 7: {
                        return String.valueOf(this.name) + " $ll, Y";
                    }
                    case 8: {
                        return String.valueOf(this.name) + " ($llhh)";
                    }
                    case 9: {
                        return String.valueOf(this.name) + " ($ll, X)";
                    }
                    case 10: {
                        return String.valueOf(this.name) + " ($ll), Y";
                    }
                    case 11: {
                        return String.valueOf(this.name) + " $llhh";
                    }
                }
                break;
            }
            ++cnt;
            ++n2;
        }
        return null;
    }

    protected void raiseAddrError(String linePart) {
        throw new RuntimeException("Address mode not supported: " + linePart);
    }

    protected void raiseSyntaxError(String linePart) {
        throw new RuntimeException("Syntax error: " + linePart);
    }

    protected int storeByte(int[] ram, int opcode, int value, int addr) {
        this.checkOpcode(opcode);
        ram[addr++] = this.opcode(opcode);
        ram[addr++] = AssemblyParser.getLowByte(value);
        return addr;
    }

    private int opcode(int opcode) {
        return opcode == -9999 ? 0 : opcode;
    }

    protected int store(int[] ram, int opcode, int value, int addr) {
        this.checkOpcode(opcode);
        ram[addr++] = this.opcode(opcode);
        ram[addr++] = AssemblyParser.getLowByte(value);
        ram[addr++] = AssemblyParser.getHighByte(value);
        return addr;
    }

    protected int store(int[] ram, int opcode, int addr) {
        this.checkOpcode(opcode);
        ram[addr++] = this.opcode(opcode);
        return addr;
    }

    protected Parameters parseParameters(CompilerConfig config, String pars, int addr, ConstantsContainer ccon, LabelsContainer lcon) {
        String part2;
        if ((pars = TermEnhancer.removeWhiteSpace(pars)).isEmpty()) {
            return null;
        }
        int addrAdd = 0;
        int pos = pars.lastIndexOf("+");
        if (pos != -1 && pos >= pars.lastIndexOf("\"")) {
            try {
                addrAdd = Integer.parseInt(pars.substring(pos + 1));
            }
            catch (Exception e) {
                throw new RuntimeException("Parse error in " + pars + "/" + addr);
            }
        }
        boolean isValue = pars.startsWith("#");
        boolean isIndirect = pars.startsWith("(");
        int indexedPos = pars.indexOf(44);
        boolean indexed = indexedPos != -1;
        pars = pars.replace("#", "");
        boolean lowByte = pars.startsWith("<");
        boolean highByte = pars.startsWith(">");
        pars = pars.replace("<", "").replace(">", "");
        String part1 = indexed ? pars.substring(0, indexedPos) : pars;
        String string = part2 = indexed ? VarUtils.toUpper(pars.substring(indexedPos + 1)) : "";
        if (!(!isIndirect || part2.isEmpty() && part1.endsWith(")") || part2.endsWith(")") && part2.startsWith("X") || part1.endsWith(")") && part2.startsWith("Y"))) {
            throw new RuntimeException("Invalid indirect addressing: " + pars);
        }
        part1 = this.removeBrackets(part1);
        part2 = this.removeBrackets(part2);
        Parameters par = new Parameters();
        par.setX(part2.startsWith("X"));
        par.setY(part2.startsWith("Y"));
        par.setIndirect(isIndirect);
        if (pars.equalsIgnoreCase("a")) {
            par.setRegister(pars);
            return par;
        }
        int val = AssemblyParser.getValue(config, part1, addr, ccon, lcon, lowByte, highByte, addrAdd, false);
        if (lowByte) {
            val = AssemblyParser.getLowByte(val);
        } else if (highByte) {
            val = AssemblyParser.getHighByte(val);
        }
        if (isValue) {
            par.setValue(val);
        } else {
            par.setAddr(val);
            if (val < 256) {
                par.setZeropage(!part1.trim().endsWith("\\"));
            }
        }
        return par;
    }

    protected void raiseOpcodeError(int opcode) {
        throw new RuntimeException("Address mode not supported: " + opcode);
    }

    private String removeBrackets(String part1) {
        return part1.replace("(", "").replace(")", "");
    }

    private void checkOpcode(int opcode) {
        if (opcode == 0) {
            this.raiseOpcodeError(opcode);
        }
    }
}

