/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.elements.systemvars;

import com.sixtyfour.elements.Variable;
import com.sixtyfour.system.Machine;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimeDate
extends Variable {
    private SimpleDateFormat sdf = new SimpleDateFormat("HHmmss");
    private long initTime = 0L;
    private long setTime = 0L;

    public TimeDate() {
        super("TI$", "000000");
        this.setSystem(true);
    }

    @Override
    public Object getValue() {
        return this.sdf.format(this.getIntervalValue());
    }

    public Date getIntervalValue() {
        long now = System.currentTimeMillis();
        long dif = now - this.setTime;
        long add = this.initTime + dif;
        return new Date(add);
    }

    @Override
    public Object eval(Machine machine) {
        return this.getValue();
    }

    @Override
    public void setValue(Object value) {
        super.setValue(value);
        if (value == null || value.toString().isEmpty()) {
            return;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("HHmmss");
            String val = value.toString();
            if (val.length() != 6) {
                throw new RuntimeException();
            }
            Date date = sdf.parse(val);
            this.initTime = date.getTime();
            this.setTime = System.currentTimeMillis();
        }
        catch (Exception e) {
            throw new RuntimeException("Illegal quantity error: " + value);
        }
    }
}

