/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.extensions;

import com.sixtyfour.config.MemoryConfig;
import com.sixtyfour.elements.Variable;
import com.sixtyfour.elements.commands.Command;
import com.sixtyfour.elements.functions.Function;
import com.sixtyfour.system.Machine;
import java.util.List;
import java.util.Map;

public interface BasicExtension {
    public List<Command> getCommands();

    public List<Function> getFunctions();

    public List<String> getAdditionalIncludes();

    public List<Variable> getSystemVariables();

    public void reset(Machine var1);

    public Map<String, Integer> getLabel2Constant();

    default public boolean isSingleSided(String function) {
        if (this.getFunctions() == null) {
            return false;
        }
        for (Function fun : this.getFunctions()) {
            if (!fun.isNativeFunction(function)) continue;
            return true;
        }
        return false;
    }

    default public boolean applyOperation(String function, List<String> code) {
        if (this.getFunctions() == null) {
            return false;
        }
        for (Function fun : this.getFunctions()) {
            boolean added;
            if (!fun.isNativeFunction(function) || !(added = fun.addNativeFunctionCall(code))) continue;
            return true;
        }
        return false;
    }

    default public boolean adjustMemoryConfig(Machine machine, MemoryConfig config) {
        return false;
    }
}

