/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.extensions.graphics;

import com.sixtyfour.extensions.graphics.commands.impl.FloodFiller;
import com.sixtyfour.extensions.graphics.commands.impl.FontProvider;
import com.sixtyfour.extensions.graphics.commands.impl.Shape;
import com.sixtyfour.extensions.textmode.ConsoleDevice;
import com.sixtyfour.plugins.PrintConsumer;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.Colors;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.WeakHashMap;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class GraphicsDevice
implements PrintConsumer {
    private static Map<Machine, GraphicsDevice> machine2window = new WeakHashMap<Machine, GraphicsDevice>();
    private JFrame frame = null;
    private BufferedImage screen = null;
    private BufferedImage backBuffer = null;
    private BufferedImage copyBuffer = null;
    private Graphics2D gscreen = null;
    private Graphics2D gbackBuffer = null;
    private Graphics2D gcopyBuffer = null;
    private boolean filled = false;
    private int width = 0;
    private int height = 0;
    private int[] pixels = null;
    private Color color = Color.white;
    private Map<Integer, Shape> shapes = new HashMap<Integer, Shape>();
    private int cursorX = 0;
    private int cursorY = 0;
    private RenderingHints noAa = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    private RenderingHints aa = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private Queue<Character> keysPressed = new LinkedList<Character>();

    public static GraphicsDevice getDevice(Machine machine) {
        return machine2window.get(machine);
    }

    public static GraphicsDevice openDevice(Machine machine, int x, int y) {
        GraphicsDevice window;
        if (x <= 0) {
            x = 320;
        }
        if (y <= 0) {
            y = 200;
        }
        if ((window = machine2window.get(machine)) == null) {
            window = new GraphicsDevice(x, y);
            machine2window.put(machine, window);
        }
        return window;
    }

    private GraphicsDevice(int x, int y) {
        System.setProperty("sun.java2d.d3d", "false");
        this.width = x;
        this.height = y;
        this.frame = new JFrame("Graphics " + x + "*" + y);
        this.frame.setLayout(new BorderLayout());
        this.frame.setDefaultCloseOperation(1);
        this.frame.addWindowStateListener(new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent e) {
                if (e.getNewState() == 201) {
                    GraphicsDevice.this.removeFromMap();
                }
            }
        });
        this.frame.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void keyPressed(KeyEvent e) {
                Queue queue = GraphicsDevice.this.keysPressed;
                synchronized (queue) {
                    if (!GraphicsDevice.this.keysPressed.contains(Character.valueOf(e.getKeyChar()))) {
                        GraphicsDevice.this.keysPressed.add(Character.valueOf(e.getKeyChar()));
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void keyReleased(KeyEvent e) {
                Queue queue = GraphicsDevice.this.keysPressed;
                synchronized (queue) {
                    while (GraphicsDevice.this.keysPressed.remove(Character.valueOf(e.getKeyChar()))) {
                    }
                }
            }
        });
        this.screen = new BufferedImage(x, y, 2);
        this.gscreen = this.screen.createGraphics();
        this.gscreen.setColor(Color.BLACK);
        this.gscreen.fillRect(0, 0, x, y);
        this.gscreen.setColor(this.color);
        this.gscreen.setRenderingHints(this.noAa);
        JLabel label = new JLabel();
        label.setIcon(new ImageIcon(this.screen));
        label.setPreferredSize(new Dimension(x, y));
        this.frame.add((Component)label, "Center");
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void dispose() {
        this.shapes.clear();
        this.removeFromMap();
    }

    public void setBufferMode(boolean doubleBuffer) {
        if (doubleBuffer) {
            if (this.backBuffer == null) {
                this.backBuffer = new BufferedImage(this.width, this.height, 2);
                this.gbackBuffer = this.backBuffer.createGraphics();
                this.gbackBuffer.setColor(Color.BLACK);
                this.gbackBuffer.fillRect(0, 0, this.width, this.height);
                this.gbackBuffer.setColor(this.color);
                this.pixels = null;
            }
        } else if (this.backBuffer != null) {
            this.backBuffer = null;
            this.gbackBuffer.dispose();
            this.gbackBuffer = null;
            this.pixels = null;
        }
    }

    public void addShape(Shape shape) {
        this.shapes.put(shape.getId(), shape);
    }

    public int addShape(String shapeName) {
        BufferedImage img = null;
        try {
            img = ImageIO.read(new File(shapeName));
        }
        catch (Exception e) {
            return -1;
        }
        Shape shape = new Shape(img);
        this.addShape(shape);
        return shape.getId();
    }

    public void color(int r, int g, int b, int a) {
        this.color = new Color(r & 0xFF, g & 0xFF, b & 0xFF, a & 0xFF);
        this.getContext().setColor(this.color);
        if (this.gbackBuffer != null) {
            this.gscreen.setColor(this.color);
        }
    }

    public void line(int xs, int ys, int xe, int ye) {
        this.getContext().drawLine(xs, ys, xe, ye);
        this.update();
    }

    public void plot(int x, int y) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            this.getScreen().setRGB(x, y, this.color.getRGB());
        }
        this.update();
    }

    public void circle(int x, int y, int xr, int yr) {
        if (this.filled) {
            this.getContext().fillOval(x - xr, y - yr, xr * 2, yr * 2);
        } else {
            this.getContext().drawOval(x - xr, y - yr, xr * 2, yr * 2);
        }
        this.update();
    }

    public void rect(int x1, int y1, int x2, int y2) {
        if (this.filled) {
            this.getContext().fillRect(x1, y1, x2 - x1 + 1, y2 - y1 + 1);
        } else {
            this.getContext().drawRect(x1, y1, x2 - x1 + 1, y2 - y1 + 1);
        }
        this.update();
    }

    public void setFillMode(boolean filled) {
        this.filled = filled;
    }

    public void clear() {
        this.getContext().fillRect(0, 0, this.width, this.height);
        this.update();
    }

    public void fill(int x, int y) {
        if (this.pixels == null) {
            DataBufferInt data = (DataBufferInt)this.getScreen().getRaster().getDataBuffer();
            this.pixels = data.getData();
        }
        new FloodFiller().fill(this.pixels, this.width, this.height, x, y, this.color);
        this.update();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void save(Machine machine, String name) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(name));
                try {
                    try (ImageOutputStream ios = ImageIO.createImageOutputStream(bos);){
                        Iterator<ImageWriter> itty = ImageIO.getImageWritersBySuffix("png");
                        if (itty.hasNext()) {
                            ImageWriter iw = itty.next();
                            ImageWriteParam iwp = iw.getDefaultWriteParam();
                            iw.setOutput(ios);
                            iw.write(null, new IIOImage(this.getScreen(), null, null), iwp);
                        }
                    }
                    if (bos == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (bos == null) throw throwable;
                    bos.close();
                    throw throwable;
                }
                bos.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void drawShape(int id, int x, int y, int xd, int yd) {
        Shape shape = this.shapes.get(id);
        if (shape == null) {
            throw new RuntimeException("Undefined shape " + id);
        }
        shape.paint(this.getContext(), x, y, xd, yd);
        this.update();
    }

    public void drawRotatedShape(int id, int x, int y, float zoom, float rot) {
        Shape shape = this.shapes.get(id);
        if (shape == null) {
            throw new RuntimeException("Undefined shape " + id);
        }
        shape.rotateAndPaint(this.getContext(), x, y, zoom, rot);
        this.update();
    }

    public void flip() {
        if (this.backBuffer == null) {
            return;
        }
        this.gscreen.drawImage((Image)this.backBuffer, 0, 0, null);
        this.frame.repaint();
    }

    public void setCursor(int x, int y) {
        this.cursorX = x;
        this.cursorY = y;
    }

    public void setFont(String fontName, int style, int size) {
        Font font = FontProvider.getFont(fontName, style, size);
        this.getContext().setFont(font);
        if (this.gbackBuffer != null) {
            this.gscreen.setFont(font);
        }
    }

    @Override
    public void print(int id, String txt) {
        this.println(id, txt);
    }

    @Override
    public void println(int id, String txt) {
        Graphics2D context = this.getContext();
        context.drawString(txt, this.cursorX, this.cursorY);
        this.cursorX = (int)((double)this.cursorX + context.getFontMetrics().getStringBounds(txt, this.getContext()).getWidth());
        this.update();
    }

    @Override
    public void systemPrint(int id, String txt) {
        System.err.print(String.valueOf(id) + "/" + txt);
    }

    @Override
    public void systemPrintln(int id, String txt) {
        System.err.println(String.valueOf(id) + "/" + txt);
    }

    public void setAAMode(boolean useAA) {
        if (useAA) {
            this.getContext().setRenderingHints(this.aa);
        } else {
            this.getContext().setRenderingHints(this.noAa);
        }
        if (this.gbackBuffer != null) {
            this.gscreen.setRenderingHints(this.getContext().getRenderingHints());
        }
    }

    public void copy(int xs, int ys, int xe, int ye, int xt, int yt) {
        int tmp = 0;
        if (xs > xe) {
            tmp = xe;
            xe = xs;
            xs = tmp;
        }
        if (ys > ye) {
            tmp = ye;
            ye = ys;
            ys = tmp;
        }
        this.internalCopy(xs, ys, xe, ye, xt, yt);
    }

    public int getShape(int xs, int ys, int xe, int ye) {
        BufferedImage shapeImage = new BufferedImage(xe - xs, ye - ys, 2);
        Graphics2D sg = shapeImage.createGraphics();
        sg.drawImage(this.getScreen(), 0, 0, xe - xs, ye - ys, xs, ys, xe, ye, null);
        sg.dispose();
        Shape shape = new Shape(shapeImage);
        this.addShape(shape);
        return shape.getId();
    }

    public int linkShape(Machine machine, int update) {
        ConsoleDevice console = ConsoleDevice.getDevice(machine);
        if (console == null) {
            return this.getShape(0, 0, 1, 1);
        }
        if (update != 0) {
            Shape shape = new Shape(console.getScreen());
            this.addShape(shape);
            return shape.getId();
        }
        BufferedImage conImg = console.getScreen();
        BufferedImage shapeImage = new BufferedImage(conImg.getWidth(), conImg.getHeight(), 2);
        Graphics2D sg = shapeImage.createGraphics();
        sg.drawImage(conImg, 0, 0, conImg.getWidth(), conImg.getHeight(), null);
        sg.dispose();
        Shape shape = new Shape(shapeImage);
        this.addShape(shape);
        return shape.getId();
    }

    public int spriteShape(Machine machine, int address, boolean multicolor) {
        BufferedImage shapeImage = new BufferedImage(24, 21, 2);
        int[] ram = machine.getRam();
        int col0 = 0;
        int col1 = 0xFF000000 | Colors.COLORS[ram[53287] & 0xF];
        int col2 = 0xFF000000 | Colors.COLORS[ram[53285] & 0xF];
        int col3 = 0xFF000000 | Colors.COLORS[ram[53286] & 0xF];
        boolean[] bits = new boolean[8];
        int x = 0;
        int y = 0;
        int i = 0;
        while (i < 63) {
            int col = ram[address + i];
            int cnt = 0;
            int p = 7;
            while (p >= 0) {
                int pow = (int)Math.pow(2.0, p);
                bits[cnt++] = (col & pow) == pow;
                --p;
            }
            if (!multicolor) {
                p = 0;
                while (p < bits.length) {
                    shapeImage.setRGB(x++, y, bits[p] ? col1 : col0);
                    ++p;
                }
            } else {
                p = 0;
                while (p < bits.length) {
                    int cl = col0;
                    if (bits[p] && bits[p + 1]) {
                        cl = col3;
                    } else if (!bits[p] && bits[p + 1]) {
                        cl = col2;
                    } else if (bits[p] && !bits[p + 1]) {
                        cl = col1;
                    }
                    shapeImage.setRGB(x++, y, cl);
                    shapeImage.setRGB(x++, y, cl);
                    p += 2;
                }
            }
            if (i % 3 == 2) {
                ++y;
                x = 0;
            }
            ++i;
        }
        Shape shape = new Shape(shapeImage);
        this.addShape(shape);
        return shape.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Character gget(String allowedChars) {
        Queue<Character> queue = this.keysPressed;
        synchronized (queue) {
            Character chr = this.keysPressed.poll();
            if (chr != null) {
                if (allowedChars != null && allowedChars.length() > 0) {
                    while (chr != null && allowedChars.indexOf(chr.charValue()) == -1) {
                        chr = this.keysPressed.poll();
                    }
                }
                if (chr != null) {
                    this.keysPressed.add(chr);
                }
            }
            return chr;
        }
    }

    private void internalCopy(int xs, int ys, int xe, int ye, int xt, int yt) {
        if (this.copyBuffer == null) {
            this.copyBuffer = new BufferedImage(this.width, this.height, 2);
            this.gcopyBuffer = this.copyBuffer.createGraphics();
        }
        this.gcopyBuffer.drawImage(this.getScreen(), 0, 0, xe - xs, ye - ys, xs, ys, xe, ye, null);
        this.getContext().drawImage(this.copyBuffer, xt, yt, xt + xe - xs, yt + ye - ys, 0, 0, xe - xs, ye - ys, null);
        this.update();
    }

    private void update() {
        if (this.backBuffer == null) {
            this.frame.repaint();
        }
    }

    private Graphics2D getContext() {
        if (this.gbackBuffer != null) {
            return this.gbackBuffer;
        }
        return this.gscreen;
    }

    private BufferedImage getScreen() {
        if (this.backBuffer != null) {
            return this.backBuffer;
        }
        return this.screen;
    }

    private void removeFromMap() {
        ArrayList<Machine> keys = new ArrayList<Machine>();
        for (Map.Entry<Machine, GraphicsDevice> entry : machine2window.entrySet()) {
            if (entry.getValue() != this) continue;
            keys.add(entry.getKey());
            this.close();
        }
        for (Machine machine : keys) {
            machine2window.remove(machine);
        }
    }

    private void close() {
        this.gscreen.dispose();
        if (this.gbackBuffer != null) {
            this.gbackBuffer.dispose();
        }
        if (this.gcopyBuffer != null) {
            this.gcopyBuffer.dispose();
        }
        this.frame.setVisible(false);
        this.frame.dispose();
    }
}

