/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.extensions.graphics.commands;

import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.extensions.graphics.GraphicsDevice;
import com.sixtyfour.extensions.graphics.commands.AbstractGraphicsCommand;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.system.BasicProgramCounter;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.List;

public class Circle
extends AbstractGraphicsCommand {
    public Circle() {
        super("CIRCLE");
    }

    @Override
    public String parse(CompilerConfig config, String linePart, int lineCnt, int lineNumber, int linePos, boolean lastPos, Machine machine) {
        String ret = super.parse(config, linePart, lineCnt, lineNumber, linePos, lastPos, machine, 3, 1);
        List<Atom> pars = Parser.getParameters(this.term);
        this.checkTypes(pars, linePart, Type.STRING, Type.STRING, Type.STRING, Type.STRING);
        return ret;
    }

    @Override
    public BasicProgramCounter execute(CompilerConfig config, Machine machine) {
        GraphicsDevice window;
        Atom xr;
        List<Atom> pars = Parser.getParameters(this.term);
        Atom xs = pars.get(0);
        Atom ys = pars.get(1);
        Atom yr = xr = pars.get(2);
        if (pars.size() > 3) {
            yr = pars.get(3);
        }
        if ((window = GraphicsDevice.getDevice(machine)) != null) {
            int xri = VarUtils.getInt(xr.eval(machine));
            window.circle(VarUtils.getInt(xs.eval(machine)), VarUtils.getInt(ys.eval(machine)), xri, xr == yr ? xri : VarUtils.getInt(yr.eval(machine)));
        }
        return null;
    }
}

