/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.extensions.graphics.commands;

import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.commands.Print;
import com.sixtyfour.extensions.graphics.GraphicsDevice;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.plugins.PrintConsumer;
import com.sixtyfour.system.BasicProgramCounter;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.List;

public class Gprint
extends Print {
    private List<Atom> pars;

    public Gprint() {
        super("GPRINT");
    }

    @Override
    public String parse(CompilerConfig config, String linePart, int lineCnt, int lineNumber, int linePos, boolean lastPos, Machine machine) {
        this.lineCnt = lineCnt;
        this.linePos = linePos;
        this.lineNumber = lineNumber;
        String[] partys = linePart.substring(6).split(",");
        if (partys.length < 3) {
            throw new RuntimeException("Syntax error: " + this);
        }
        int dif = linePart.indexOf(44, linePart.indexOf(44) + 1);
        String terms = linePart.substring(0, dif);
        this.term = Parser.getTerm(config, this, terms, machine, true);
        this.pars = Parser.getParameters(this.term);
        this.checkTypes(this.pars, linePart, Type.STRING, Type.STRING);
        linePart = linePart.substring(dif + 1);
        List<Print.PrintPart> parts = this.getParts(linePart, config);
        if (parts.size() == 0) {
            Print.PrintPart newLine = new Print.PrintPart("\"\"", ' ');
            parts.add(newLine);
        }
        for (Print.PrintPart part : parts) {
            part.term = Parser.getTerm(config, part.part, machine, false, true);
        }
        this.parts = parts;
        return null;
    }

    @Override
    protected BasicProgramCounter execute(Machine machine, PrintConsumer consumer, int printId) {
        GraphicsDevice window = GraphicsDevice.getDevice(machine);
        if (window != null) {
            Atom x = this.pars.get(0);
            Atom y = this.pars.get(1);
            window.setCursor(VarUtils.getInt(x.eval(machine)), VarUtils.getInt(y.eval(machine)));
            return super.execute(machine, window, printId);
        }
        return null;
    }
}

