/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.extensions.graphics.commands;

import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.extensions.graphics.commands.AbstractGraphicsCommand;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.system.BasicProgramCounter;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.List;

public class Limit
extends AbstractGraphicsCommand {
    private long frameTime;
    private long lastTime;
    private long lastDif;

    public Limit() {
        super("LIMIT");
    }

    @Override
    public String parse(CompilerConfig config, String linePart, int lineCnt, int lineNumber, int linePos, boolean lastPos, Machine machine) {
        String ret = super.parse(config, linePart, lineCnt, lineNumber, linePos, lastPos, machine, 1, 0);
        List<Atom> pars = Parser.getParameters(this.term);
        this.checkTypes(pars, linePart, Type.STRING);
        return ret;
    }

    @Override
    public BasicProgramCounter execute(CompilerConfig config, Machine machine) {
        List<Atom> pars = Parser.getParameters(this.term);
        Atom m = pars.get(0);
        this.limit(VarUtils.getInt(m.eval(machine)));
        return null;
    }

    private void limit(int fps) {
        if (fps <= 0) {
            return;
        }
        this.frameTime = 1000000000L / (long)fps;
        long now = System.nanoTime();
        long dif = now - this.lastTime;
        if (dif < 0L) {
            dif = this.lastDif;
        }
        this.lastDif = dif;
        if (dif < this.frameTime) {
            try {
                long waitTime = (this.frameTime - dif) / 1000000L;
                Thread.sleep(waitTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.lastTime = System.nanoTime();
    }
}

