/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.extensions.graphics.commands.impl;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.PixelGrabber;

public class Rotator {
    private static final int ACCURACY = 8192;
    private static final int ACC_SHIFT = 13;
    private BufferedImage target = null;
    private BufferedImage oTarget = null;
    private int[] texels = null;
    private int[] pixels = null;
    private int[] oPixels = null;
    private int width = 0;
    private int height = 0;
    private int tWidth = 0;
    private int tHeight = 0;
    private int pivotX = 0;
    private int pivotY = 0;
    private int centerX = 0;
    private int centerY = 0;
    private float zoom = 1.0f;
    private float orgZoom = 1.0f;
    private boolean overSample = false;
    private int targetSize = 0;

    public Rotator(BufferedImage source, int targetSize, boolean overSample) {
        this.overSample = overSample;
        this.init(source, targetSize);
    }

    public void setZoom(float zoom) {
        this.orgZoom = zoom;
        this.zoom = 1.0f / zoom;
    }

    public float getZoom() {
        return this.orgZoom;
    }

    public int getTargetSize() {
        return this.targetSize;
    }

    public void setRotationPivot(int xp, int yp) {
        int shft = 0;
        if (this.overSample) {
            shft = 1;
        }
        if (xp < 0 || xp >= this.tWidth >> shft || yp < 0 || yp >= this.tHeight >> shft) {
            throw new RuntimeException("Rotation pivot out of bounds!");
        }
        this.pivotX = xp << shft;
        this.pivotY = yp << shft;
    }

    public BufferedImage createView(float xPos, float yPos, float angle) {
        float[] p0 = new float[2];
        float[] p1 = new float[2];
        float[] p3 = new float[2];
        int dx = this.centerX - this.pivotX;
        int dy = this.centerY - this.pivotY;
        p0[0] = -this.centerX + dx;
        p0[1] = -this.centerY + dy;
        p1[0] = this.centerX + dx;
        p1[1] = -this.centerY + dy;
        p3[0] = -this.centerX + dx;
        p3[1] = this.centerY + dy;
        float zoom = this.zoom;
        if (this.overSample) {
            zoom /= 2.0f;
        }
        int i = 0;
        while (i < 2) {
            int n = i;
            p0[n] = p0[n] * zoom;
            int n2 = i;
            p1[n2] = p1[n2] * zoom;
            int n3 = i++;
            p3[n3] = p3[n3] * zoom;
        }
        this.rotate(p0, angle);
        this.rotate(p1, angle);
        this.rotate(p3, angle);
        float deltaXU = p1[0] - p0[0];
        float deltaXV = p1[1] - p0[1];
        float deltaYU = p3[0] - p0[0];
        float deltaYV = p3[1] - p0[1];
        deltaXU /= (float)this.tWidth;
        deltaXV /= (float)this.tWidth;
        deltaYU /= (float)this.tHeight;
        deltaYV /= (float)this.tHeight;
        float px = p0[0] + xPos;
        float py = p0[1] + yPos;
        int end = this.texels.length;
        int idXU = (int)(deltaXU * 8192.0f);
        int idXV = (int)(deltaXV * 8192.0f);
        int idYU = (int)(deltaYU * 8192.0f);
        int idYV = (int)(deltaYV * 8192.0f);
        int ipx = (int)(px * 8192.0f);
        int ipy = (int)(py * 8192.0f);
        int pos = 0;
        int y = 0;
        while (y < this.tHeight) {
            int ppx = ipx;
            int ppy = ipy;
            int endPos = pos + this.tWidth;
            int x = pos;
            while (x < endPos) {
                int oppx = ppx >> 13;
                int texelPos = (ppy >> 13) * this.width + oppx;
                this.pixels[x] = texelPos < end && texelPos >= 0 && oppx >= 0 && oppx < this.width ? this.texels[texelPos] : 0;
                ppx += idXU;
                ppy += idXV;
                ++x;
            }
            pos += this.tWidth;
            ipy += idYV;
            ipx += idYU;
            ++y;
        }
        if (this.overSample) {
            this.downSample();
            return this.oTarget;
        }
        return this.target;
    }

    public Image getTargetImage() {
        if (this.overSample) {
            this.downSample();
            return this.oTarget;
        }
        return this.target;
    }

    private void downSample() {
        int bpos = 0;
        int length = this.pixels.length - this.tWidth - 1;
        int opos = 0;
        int i = 0;
        while (bpos < length) {
            int p1 = this.pixels[bpos];
            int p2 = this.pixels[bpos + 1];
            int p3 = this.pixels[bpos + this.tWidth];
            int p4 = this.pixels[bpos + this.tWidth + 1];
            int pr = (p1 >> 16 & 0xFF) + (p2 >> 16 & 0xFF) + (p3 >> 16 & 0xFF) + (p4 >> 16 & 0xFF) >> 2 << 16;
            int pg = (p1 >> 8 & 0xFF) + (p2 >> 8 & 0xFF) + (p3 >> 8 & 0xFF) + (p4 >> 8 & 0xFF) >> 2 << 8;
            int pb = (p1 & 0xFF) + (p2 & 0xFF) + (p3 & 0xFF) + (p4 & 0xFF) >> 2;
            this.oPixels[opos] = pr | pg | pb;
            ++opos;
            bpos += 2;
            if ((i += 2) < this.tWidth) continue;
            i = 0;
            bpos += this.tWidth;
        }
    }

    private void init(BufferedImage img, int targetSize) {
        this.height = img.getHeight();
        this.width = img.getWidth();
        this.texels = new int[this.width * this.height];
        PixelGrabber pg = new PixelGrabber(img, 0, 0, this.width, this.height, this.texels, 0, this.width);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        int shft = 0;
        if (this.overSample) {
            shft = 1;
        }
        this.tWidth = targetSize << shft;
        this.tHeight = targetSize << shft;
        this.target = new BufferedImage(this.tWidth, this.tHeight, 2);
        this.pixels = ((DataBufferInt)this.target.getRaster().getDataBuffer()).getData();
        if (this.overSample) {
            this.oTarget = new BufferedImage(targetSize, targetSize, 2);
            this.oPixels = ((DataBufferInt)this.oTarget.getRaster().getDataBuffer()).getData();
        }
        this.pivotX = this.tWidth >> 1;
        this.pivotY = this.tHeight >> 1;
        this.centerX = this.pivotX;
        this.centerY = this.pivotY;
    }

    private void rotate(float[] point, float angle) {
        if (point.length != 2) {
            throw new RuntimeException("Array size has to be 2 but is: " + point.length);
        }
        float oldX = point[0];
        float oldY = point[1];
        float sinZ = (float)Math.sin(angle);
        float cosZ = (float)Math.cos(angle);
        point[0] = oldX * cosZ - oldY * sinZ;
        point[1] = oldX * sinZ + oldY * cosZ;
    }
}

