/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.extensions.graphics.commands.impl;

import com.sixtyfour.extensions.graphics.commands.impl.Rotator;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class Shape {
    private static int currentId = 0;
    private int id = currentId++;
    private BufferedImage shape;
    private BufferedImage rotatedShape = null;
    private Rotator rotator = null;
    private int targetSize = -1;
    private float oldRotation = 0.0f;
    private float oldZoom = 0.0f;

    public Shape(BufferedImage shape) {
        this.shape = shape;
    }

    public int getId() {
        return this.id;
    }

    public void paint(Graphics2D context, int x, int y, int xd, int yd) {
        if (xd == -1) {
            context.drawImage((Image)this.shape, x, y, null);
        } else {
            context.drawImage(this.shape, x, y, xd, yd, null);
        }
    }

    public void rotateAndPaint(Graphics2D context, int x, int y, float zoom, float rot) {
        int md = (int)((Math.sqrt(this.shape.getWidth() * this.shape.getWidth() + this.shape.getHeight() * this.shape.getHeight()) + 0.5) * (double)Math.max(1.0f, zoom));
        if ((md = md / 256 * 512) < 256) {
            md = 256;
        }
        boolean created = false;
        if (this.rotator == null || this.targetSize < md) {
            this.rotator = new Rotator(this.shape, md, false);
            this.rotator.setRotationPivot(md / 2, md / 2);
            created = true;
            this.targetSize = md;
        }
        if (this.rotatedShape == null || rot != this.oldRotation || created || zoom != this.oldZoom) {
            this.rotator.setZoom(zoom);
            this.rotatedShape = this.rotator.createView(this.shape.getWidth() / 2, this.shape.getHeight() / 2, rot);
            this.oldRotation = rot;
            this.oldZoom = zoom;
        }
        float xf = x;
        float yf = y;
        context.drawImage((Image)this.rotatedShape, (int)(xf -= (float)md / 2.0f - (float)this.shape.getWidth() / 2.0f), (int)(yf -= (float)md / 2.0f - (float)this.shape.getHeight() / 2.0f), null);
    }
}

