/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.extensions.graphics.functions;

import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.functions.AbstractFunction;
import com.sixtyfour.extensions.graphics.GraphicsDevice;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.List;

public class GetShape
extends AbstractFunction {
    public GetShape() {
        super("GETSHAPE");
    }

    @Override
    public Type getType() {
        return Type.INTEGER;
    }

    @Override
    public Object eval(Machine machine) {
        List<Atom> pars = Parser.getParameters(this.term);
        if (pars.size() != 4) {
            throw new RuntimeException("Wrong number of parameters: " + this.term);
        }
        Atom xs = pars.get(0);
        this.checkType(xs);
        Atom ys = pars.get(1);
        this.checkType(ys);
        Atom xe = pars.get(2);
        this.checkType(xe);
        Atom ye = pars.get(3);
        this.checkType(ye);
        GraphicsDevice window = GraphicsDevice.getDevice(machine);
        if (window != null) {
            return window.getShape(VarUtils.getInt(xs.eval(machine)), VarUtils.getInt(ys.eval(machine)), VarUtils.getInt(xe.eval(machine)), VarUtils.getInt(ye.eval(machine)));
        }
        throw new RuntimeException("Graphics mode not enabled!");
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    private void checkType(Atom x) {
        if (x.getType().equals((Object)Type.STRING)) {
            throw new RuntimeException("Type mismatch error: " + this);
        }
    }
}

