/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.extensions.graphics.functions;

import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.functions.AbstractFunction;
import com.sixtyfour.extensions.graphics.GraphicsDevice;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.List;

public class LinkShape
extends AbstractFunction {
    public LinkShape() {
        super("LINKSHAPE");
    }

    @Override
    public Type getType() {
        return Type.INTEGER;
    }

    @Override
    public Object eval(Machine machine) {
        List<Atom> pars = Parser.getParameters(this.term);
        if (pars.size() != 1) {
            throw new RuntimeException("Wrong number of parameters: " + this.term);
        }
        Atom type = pars.get(0);
        this.checkType(type);
        GraphicsDevice window = GraphicsDevice.getDevice(machine);
        if (window != null) {
            return window.linkShape(machine, VarUtils.getInt(type.eval(machine)));
        }
        throw new RuntimeException("Graphics mode not enabled!");
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    private void checkType(Atom x) {
        if (x.getType().equals((Object)Type.STRING)) {
            throw new RuntimeException("Type mismatch error: " + this);
        }
    }
}

