/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.extensions.graphics.functions;

import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.functions.AbstractFunction;
import com.sixtyfour.extensions.graphics.GraphicsDevice;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.List;

public class SpriteShape
extends AbstractFunction {
    public SpriteShape() {
        super("SPRITESHAPE");
    }

    @Override
    public Type getType() {
        return Type.INTEGER;
    }

    @Override
    public Object eval(Machine machine) {
        List<Atom> pars = Parser.getParameters(this.term);
        if (pars.size() != 2) {
            throw new RuntimeException("Wrong number of parameters: " + this.term);
        }
        Atom addr = pars.get(0);
        this.checkType(addr);
        Atom type = pars.get(1);
        this.checkType(type);
        GraphicsDevice window = GraphicsDevice.getDevice(machine);
        if (window != null) {
            return window.spriteShape(machine, VarUtils.getInt(addr.eval(machine)), VarUtils.getInt(type.eval(machine)) == 1);
        }
        throw new RuntimeException("Graphics mode not enabled!");
    }

    private void checkType(Atom x) {
        if (x.getType().equals((Object)Type.STRING)) {
            throw new RuntimeException("Type mismatch error: " + this);
        }
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }
}

