/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.extensions.textmode;

import com.sixtyfour.plugins.InputProvider;
import com.sixtyfour.plugins.MemoryListener;
import com.sixtyfour.plugins.OutputChannel;
import com.sixtyfour.plugins.PrintConsumer;
import com.sixtyfour.plugins.SystemCallListener;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.Colors;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class ConsoleDevice
implements OutputChannel,
SystemCallListener,
MemoryListener,
InputProvider {
    private static final int COLOR_RAM = 55296;
    private static final int TEXT_RAM = 1024;
    private static Map<Machine, ConsoleDevice> machine2window = new WeakHashMap<Machine, ConsoleDevice>();
    private String charset;
    private JFrame frame = null;
    private BufferedImage screen = null;
    private Graphics2D gscreen = null;
    private int width = 0;
    private int height = 0;
    private int color = 14;
    private int bgColor = 6;
    private int baseLine = 0;
    private int cursorX = 0;
    private int cursorY = 0;
    private boolean reverseMode = false;
    private boolean graphicsFontUsed = true;
    private RenderingHints noAa = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    private Queue<Character> keysPressed = new LinkedList<Character>();
    private SystemCallListener oldSystemCallListener = null;
    private MemoryListener oldMemoryListener = null;
    private OutputChannel oldOutputChannel = null;
    private InputProvider oldInputProvider = null;
    private int[] ram;
    private Color[] colors = new Color[Colors.COLORS.length];
    private StringBuilder inputString = new StringBuilder();
    private boolean inputMode = false;
    private boolean cursorMode = false;
    private boolean cursorOn = false;
    private int insertPos = -1;
    private Thread cursorThread = null;
    private boolean shiftDown = false;
    private Set<Integer> toIgnore = new HashSet<Integer>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(16);
            this.add(17);
            this.add(20);
            this.add(18);
            this.add(65406);
        }
    };

    public static ConsoleDevice getDevice(Machine machine) {
        return machine2window.get(machine);
    }

    public static ConsoleDevice openDevice(Machine machine, int consoleType, boolean clear, int x, int y) {
        ConsoleDevice window;
        if (x <= 0) {
            x = 320;
        }
        if (y <= 0) {
            y = 200;
        }
        if ((window = machine2window.get(machine)) == null) {
            window = new ConsoleDevice(machine, consoleType, clear, x, y);
            machine2window.put(machine, window);
        } else {
            window.updateScreen();
        }
        return window;
    }

    private ConsoleDevice(Machine machine, int consoleType, boolean clear, int x, int y) {
        System.setProperty("sun.java2d.d3d", "false");
        this.width = x;
        this.height = y;
        this.charset = this.createCharsetMapping();
        this.oldSystemCallListener = machine.getSystemCallListener();
        this.oldMemoryListener = machine.getMemoryListener();
        this.oldOutputChannel = machine.getOutputChannel();
        this.oldInputProvider = machine.getInputProvider();
        this.ram = machine.getRam();
        int i = 0;
        while (i < Colors.COLORS.length) {
            this.colors[i] = new Color(Colors.COLORS[i]);
            ++i;
        }
        machine.setSystemCallListener(this);
        machine.setMemoryListener(this);
        machine.setOutputChannel(this);
        machine.setInputProvider(this);
        this.frame = new JFrame("Console " + x + "*" + y);
        this.frame.setLayout(new BorderLayout());
        this.frame.setDefaultCloseOperation(1);
        this.frame.addKeyListener(new FontToggler());
        this.frame.addWindowStateListener(new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent e) {
                if (e.getNewState() == 201) {
                    ConsoleDevice.this.removeFromMap();
                }
            }
        });
        this.frame.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                char c;
                if (ConsoleDevice.this.inputMode && (Character.isDigit(c = e.getKeyChar()) || Character.isAlphabetic(c) || Character.isWhitespace(c) || "#-.,:;'+*/\"!\u00a7$%&/()][}{\u00df?\u00b4`".indexOf(c) != -1)) {
                    if (Character.isWhitespace(c)) {
                        c = ' ';
                    }
                    if (ConsoleDevice.this.insertPos == -1) {
                        ConsoleDevice.this.inputString.append(c);
                    } else {
                        ConsoleDevice.this.inputString.setCharAt(ConsoleDevice.this.insertPos, c);
                        ConsoleDevice consoleDevice = ConsoleDevice.this;
                        consoleDevice.insertPos = consoleDevice.insertPos + 1;
                        if (ConsoleDevice.this.insertPos >= ConsoleDevice.this.inputString.length()) {
                            ConsoleDevice.this.insertPos = -1;
                        }
                    }
                    ConsoleDevice.this.print(0, Character.toString(c));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void keyPressed(KeyEvent e) {
                Queue queue = ConsoleDevice.this.keysPressed;
                synchronized (queue) {
                    char kc = e.getKeyChar();
                    if (e.getKeyCode() == 10) {
                        kc = '\r';
                    }
                    if (!ConsoleDevice.this.keysPressed.contains(Character.valueOf(kc)) && !ConsoleDevice.this.toIgnore.contains(e.getKeyCode())) {
                        ConsoleDevice.this.keysPressed.add(Character.valueOf(kc));
                    }
                    ((ConsoleDevice)ConsoleDevice.this).ram[198] = ConsoleDevice.this.keysPressed.size();
                    if (ConsoleDevice.this.inputMode) {
                        switch (e.getKeyCode()) {
                            case 16: {
                                ConsoleDevice.this.shiftDown = true;
                                break;
                            }
                            case 10: {
                                ConsoleDevice.this.inputMode = false;
                                ConsoleDevice.this.cursorThread.interrupt();
                                break;
                            }
                            case 8: {
                                if (!ConsoleDevice.this.shiftDown) {
                                    if (ConsoleDevice.this.inputString.length() > 0) {
                                        if (ConsoleDevice.this.insertPos == -1) {
                                            ConsoleDevice.this.inputString.setLength(Math.max(0, ConsoleDevice.this.inputString.length() - 1));
                                            ConsoleDevice.this.pokeValue(ConsoleDevice.this.getTextRamPos(), 32, 1024);
                                            ConsoleDevice.this.setCursor(ConsoleDevice.this.cursorX - 1, ConsoleDevice.this.cursorY);
                                            ConsoleDevice.this.pokeValue(ConsoleDevice.this.getTextRamPos(), 32, 1024);
                                        } else {
                                            ConsoleDevice consoleDevice = ConsoleDevice.this;
                                            consoleDevice.insertPos = consoleDevice.insertPos - 1;
                                            if (ConsoleDevice.this.insertPos < 0) {
                                                ConsoleDevice.this.insertPos = 0;
                                            } else {
                                                ConsoleDevice.this.inputString.deleteCharAt(ConsoleDevice.this.insertPos);
                                                ConsoleDevice.this.setCursor(ConsoleDevice.this.cursorX - 1, ConsoleDevice.this.cursorY);
                                                ConsoleDevice.this.shiftLeft();
                                                ConsoleDevice.this.updateScreen();
                                            }
                                        }
                                    }
                                } else if (ConsoleDevice.this.inputString.length() > 0 && ConsoleDevice.this.insertPos != -1) {
                                    if (ConsoleDevice.this.shiftRight()) {
                                        ConsoleDevice.this.inputString.insert(ConsoleDevice.this.insertPos, ' ');
                                    }
                                    ConsoleDevice.this.updateScreen();
                                }
                                ConsoleDevice.this.cursorThread.interrupt();
                                break;
                            }
                            case 37: {
                                if (ConsoleDevice.this.insertPos == -1) {
                                    ConsoleDevice.this.insertPos = ConsoleDevice.this.inputString.length() - 1;
                                    ConsoleDevice.this.setCursor(ConsoleDevice.this.cursorX - 1, ConsoleDevice.this.cursorY);
                                } else {
                                    ConsoleDevice consoleDevice = ConsoleDevice.this;
                                    consoleDevice.insertPos = consoleDevice.insertPos - 1;
                                    if (ConsoleDevice.this.insertPos < 0) {
                                        ConsoleDevice.this.insertPos = 0;
                                    } else {
                                        ConsoleDevice.this.setCursor(ConsoleDevice.this.cursorX - 1, ConsoleDevice.this.cursorY);
                                    }
                                }
                                ConsoleDevice.this.cursorThread.interrupt();
                                break;
                            }
                            case 39: {
                                if (ConsoleDevice.this.insertPos == -1) {
                                    ConsoleDevice.this.inputString.append(' ');
                                    ConsoleDevice.this.print(0, Character.toString(' '));
                                } else {
                                    ConsoleDevice consoleDevice = ConsoleDevice.this;
                                    consoleDevice.insertPos = consoleDevice.insertPos + 1;
                                    if (ConsoleDevice.this.insertPos >= ConsoleDevice.this.inputString.length()) {
                                        ConsoleDevice.this.insertPos = -1;
                                    }
                                    ConsoleDevice.this.setCursor(ConsoleDevice.this.cursorX + 1, ConsoleDevice.this.cursorY);
                                }
                                ConsoleDevice.this.cursorThread.interrupt();
                                break;
                            }
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void keyReleased(KeyEvent e) {
                Queue queue = ConsoleDevice.this.keysPressed;
                synchronized (queue) {
                    char kc = e.getKeyChar();
                    if (e.getKeyCode() == 10) {
                        kc = '\r';
                    }
                    while (ConsoleDevice.this.keysPressed.remove(Character.valueOf(kc))) {
                    }
                    if (e.getKeyCode() == 16) {
                        ConsoleDevice.this.shiftDown = false;
                    }
                }
            }
        });
        this.screen = new BufferedImage(x, y, 2);
        this.gscreen = this.screen.createGraphics();
        this.gscreen.setColor(new Color(this.color));
        this.gscreen.setRenderingHints(this.noAa);
        JLabel label = new JLabel();
        label.setIcon(new ImageIcon(this.screen));
        label.setPreferredSize(new Dimension(x, y));
        this.frame.add((Component)label, "Center");
        this.frame.pack();
        if (clear) {
            this.clearScreen();
        }
        Font ft = this.loadFont("CommodoreServer.ttf", this.width);
        this.gscreen.setFont(ft);
        this.graphicsFontUsed = true;
        this.baseLine = this.width / 40;
        if (!clear) {
            this.updateScreen();
        }
        this.frame.setVisible(consoleType > 0);
    }

    private String createCharsetMapping() {
        StringBuilder sb = new StringBuilder();
        sb.append("@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_ !\"#$%&'()*+,-./0123456789:;<=>?`abcdefghijklmnopqrstuvwxyz{|}~\u007f");
        sb.append("\u00a0\u00a1\u00a2\u00a3\u00a4\u00a5\u00a6\u00a7\u00a8\u00a9\u00aa\u00ab\u00ac\u00ad\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u00b5\u00b6\u00b7\u00b8\u00b9\u00ba\u00bb\u00bc\u00bd\u00be\u00bf");
        sb.append("\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff");
        int i = 0;
        while (i < 32) {
            sb.append(Character.toString((char)(i + 128)));
            ++i;
        }
        sb.append(Character.toString('\u00e0'));
        i = 0;
        while (i < 31) {
            sb.append(Character.toString((char)(i + 256)));
            ++i;
        }
        sb.append("@");
        i = 0;
        while (i < 26) {
            sb.append(Character.toString((char)(i + 287)));
            ++i;
        }
        sb.append("[\\]^_ !\"#$%&'()*+,-./0123456789:;<=>?`");
        sb.append("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
        sb.append("{|}~\u007f\u00a0\u00a1\u00a2\u00a3\u00a4\u00a5\u00a6\u00a7\u00a8\u00a9\u00aa\u00ab\u00ac\u00ad\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u00b5\u00b6\u00b7\u00b8\u00b9\u00ba\u00bb\u00bc\u00bd\u00be\u00bf\u00c0");
        i = 0;
        while (i < 26) {
            sb.append(Character.toString((char)(i + 313)));
            ++i;
        }
        sb.append("\u00db\u00dc\u00dd\u00de\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff");
        sb.append(Character.toString('\u0080'));
        sb.append("\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da");
        i = 27;
        while (i < 32) {
            sb.append(Character.toString((char)(i + 128)));
            ++i;
        }
        sb.append(Character.toString('\u00e0'));
        i = 0;
        while (i < 31) {
            sb.append(Character.toString((char)(i + 256)));
            ++i;
        }
        sb.setCharAt(350, '\u0105');
        sb.setCharAt(351, '\u0153');
        sb.setCharAt(361, '\u0155');
        sb.setCharAt(378, '\uf154');
        sb.setCharAt(478, '\u00a6');
        sb.setCharAt(479, '\uf153');
        sb.setCharAt(489, '\u0155');
        sb.setCharAt(506, '\uf156');
        return sb.toString();
    }

    public void dispose() {
        this.removeFromMap();
    }

    @Override
    public void print(int id, String txt) {
        this.print(txt, false);
        this.oldOutputChannel.print(id, txt);
    }

    @Override
    public void println(int id, String txt) {
        this.print(txt, true);
        this.oldOutputChannel.println(id, txt);
    }

    @Override
    public void systemPrint(int id, String txt) {
        this.oldOutputChannel.systemPrint(id, txt);
    }

    @Override
    public void systemPrintln(int id, String txt) {
        this.oldOutputChannel.systemPrintln(id, txt);
    }

    @Override
    public int getCursor() {
        return this.cursorX;
    }

    @Override
    public void setCursor(int cursor) {
        this.cursorX = cursor;
    }

    @Override
    public void setPrintConsumer(PrintConsumer otherConsumer, int channel) {
        this.oldOutputChannel.setPrintConsumer(otherConsumer, channel);
    }

    @Override
    public PrintConsumer getPrintConsumer() {
        return this.oldOutputChannel.getPrintConsumer();
    }

    @Override
    public int getChannel() {
        return this.oldOutputChannel.getChannel();
    }

    @Override
    public void sys(int addr, Object ... params) {
        this.oldSystemCallListener.sys(addr, params);
    }

    @Override
    public float usr(Object params) {
        return this.oldSystemCallListener.usr(params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void poke(int addr, int value) {
        if (addr >= 1024 && addr <= 2023) {
            this.pokeChar(addr, value);
        } else if (addr >= 55296 && addr <= 56295) {
            this.pokeColor(addr, value);
        } else if (addr == 646) {
            this.color = value;
        } else if (addr == 53281) {
            this.bgColor = value;
            this.updateScreen();
        } else if (addr == 53272) {
            if (value == 23) {
                this.setCharset(false);
            } else if (value == 21) {
                this.setCharset(true);
            }
        } else if (addr == 198 && value == 0) {
            Queue<Character> queue = this.keysPressed;
            synchronized (queue) {
                this.keysPressed.clear();
            }
        }
        this.oldMemoryListener.poke(addr, value);
    }

    @Override
    public Integer peek(int addr) {
        if (addr == 198) {
            return this.ram[addr];
        }
        return this.oldMemoryListener.peek(addr);
    }

    @Override
    public boolean wait(int addr, int value, int inverse) {
        if (addr == 198) {
            return this.ram[addr] != value;
        }
        return this.oldMemoryListener.wait(addr, value, inverse);
    }

    public BufferedImage getScreen() {
        return this.screen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Character readKey() {
        Queue<Character> queue = this.keysPressed;
        synchronized (queue) {
            Character chr = this.keysPressed.poll();
            return chr;
        }
    }

    @Override
    public String readString() {
        this.inputString.setLength(0);
        if (!this.frame.isVisible()) {
            return null;
        }
        this.insertPos = -1;
        this.inputMode = true;
        this.startCursor();
        while (this.inputMode) {
            try {
                Thread.sleep(5L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.stopCursor();
        System.out.println("[" + this.inputString + "]");
        return this.inputString.toString();
    }

    public void setFontMode(boolean isLower) {
        this.setCharset(!isLower);
        this.update();
    }

    public void toggleFontMode() {
        this.setCharset(!this.graphicsFontUsed);
        this.update();
    }

    private void stopCursor() {
        this.cursorMode = false;
        while (this.cursorOn) {
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void startCursor() {
        this.cursorOn = true;
        this.cursorMode = true;
        this.cursorThread = new Thread(){

            @Override
            public void run() {
                int lastVal = 0;
                while (ConsoleDevice.this.cursorMode) {
                    int val;
                    int addr = ConsoleDevice.this.getTextRamPos();
                    lastVal = val = ConsoleDevice.this.ram[addr];
                    val = val < 128 ? (val += 128) : (val -= 128);
                    ConsoleDevice.this.renderValue(addr, val, 1024);
                    this.delay();
                    val = val > 128 ? (val -= 128) : (val += 128);
                    if (ConsoleDevice.this.ram[addr] == lastVal) {
                        ConsoleDevice.this.renderValue(addr, val, 1024);
                    }
                    this.delay();
                }
                ConsoleDevice.this.cursorOn = false;
            }

            private void delay() {
                try {
                    Thread.sleep(333L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.cursorThread.start();
    }

    private void setCharset(boolean graphics) {
        this.graphicsFontUsed = graphics;
        this.updateScreen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateScreen() {
        this.clearRect(0, 0, this.width, this.height, this.bgColor);
        ConsoleDevice consoleDevice = this;
        synchronized (consoleDevice) {
            int y = 0;
            while (y < 25) {
                int x = 0;
                while (x < 40) {
                    this.updateChar(x, y, false);
                    ++x;
                }
                ++y;
            }
        }
        this.update();
    }

    private void pokeChar(int addr, int value) {
        this.pokeValue(addr, value, 1024);
    }

    private void pokeColor(int addr, int value) {
        this.pokeValue(addr, value, 55296);
    }

    private void pokeValue(int addr, int value, int baseAddr) {
        int y = (addr - baseAddr) / 40;
        int x = addr - baseAddr - y * 40;
        if (y < 25 && x < 40) {
            this.ram[addr] = value;
            this.updateChar(x, y, true);
            this.update();
        }
    }

    private void renderValue(int addr, int value, int baseAddr) {
        int y = (addr - baseAddr) / 40;
        int x = addr - baseAddr - y * 40;
        if (y < 25 && x < 40) {
            int cw = this.width / 40;
            int xc = x * cw;
            int yc = y * cw;
            int offset = x + y * 40;
            this.clearRect(xc, yc, xc + cw, yc + cw, this.bgColor);
            this.getContext().setColor(this.colors[this.ram[55296 + offset] & 0xF]);
            String ch = null;
            ch = this.graphicsFontUsed ? Character.toString(this.charset.charAt(value & 0xFF)) : Character.toString(this.charset.charAt((value & 0xFF) + 256));
            this.getContext().drawString(ch, xc, yc + this.baseLine);
            this.update(xc - cw, yc - cw, cw * 3, cw * 3 + this.baseLine);
        }
    }

    private void updateChar(int x, int y, boolean clear) {
        int cw = this.width / 40;
        int xc = x * cw;
        int yc = y * cw;
        int offset = x + y * 40;
        if (clear) {
            this.clearRect(xc, yc, xc + cw, yc + cw, this.bgColor);
        }
        this.reallyPrintChar(offset, yc, xc);
    }

    private void printChar(char c) {
        int offset = this.cursorX + this.cursorY * 40;
        int cw = this.width / 40;
        int yc = this.cursorY * cw;
        int xc = this.cursorX * cw;
        int ci = this.getValueToPoke(c);
        this.ram[1024 + offset] = (ci += this.reverseMode ? 128 : 0) & 0xFF;
        this.ram[55296 + offset] = this.ram[646] & 0xF;
        this.clearRect(xc, yc, xc + cw, yc + cw, this.bgColor);
        this.reallyPrintChar(offset, yc, xc);
        this.setCursor(this.cursorX + 1, this.cursorY);
    }

    private void reallyPrintChar(int offset, int yc, int xc) {
        this.getContext().setColor(this.colors[this.ram[55296 + offset] & 0xF]);
        String ch = null;
        ch = this.graphicsFontUsed ? Character.toString(this.charset.charAt(this.ram[1024 + offset] & 0xFF)) : Character.toString(this.charset.charAt((this.ram[1024 + offset] & 0xFF) + 256));
        this.getContext().drawString(ch, xc, yc + this.baseLine);
    }

    private char getConvertedChar(char c) {
        if (c >= 'a' && c <= 'z') {
            c = (char)(c - 32);
        } else if (c >= 'A' && c <= 'Z') {
            c = (char)(c + 32);
        }
        return c;
    }

    private int getValueToPoke(char c) {
        c = this.getConvertedChar(c);
        int i = 0;
        while (i < 512) {
            char ct = this.charset.charAt(i);
            if (ct == c) {
                return i > 255 ? i - 256 : i;
            }
            ++i;
        }
        return 32;
    }

    private Font loadFont(String name, int width) {
        try {
            Font ft = Font.createFont(0, this.getClass().getResourceAsStream("/" + name));
            return ft.deriveFont((float)width / 40.0f);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load font: " + name, e);
        }
    }

    private void update() {
        this.frame.repaint();
    }

    private void update(int x, int y, int w, int h) {
        this.frame.repaint(x, y, w, h);
    }

    private Graphics2D getContext() {
        return this.gscreen;
    }

    private void clearRect(int x1, int y1, int x2, int y2, int color) {
        this.getContext().setColor(this.colors[color & 0xF]);
        this.getContext().fillRect(x1, y1, x2 - x1, y2 - y1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCursor(int x, int y) {
        ConsoleDevice consoleDevice = this;
        synchronized (consoleDevice) {
            this.cursorX = x;
            this.cursorY = y;
            if (this.cursorX > 39) {
                this.cursorX = 0;
                ++this.cursorY;
            }
            if (this.cursorX < 0) {
                if (this.cursorY == 0) {
                    this.cursorY = 0;
                    this.cursorX = 0;
                } else {
                    this.cursorX += 40;
                    --this.cursorY;
                }
            }
            if (this.cursorY < 0) {
                this.cursorY = 0;
            }
            while (this.cursorY > 24) {
                --this.cursorY;
                this.scrollUp();
            }
            this.ram[211] = this.cursorX;
            this.ram[214] = this.cursorY;
        }
    }

    private void scrollUp() {
        int i = 40;
        while (i < 1000) {
            this.ram[984 + i] = this.ram[1024 + i];
            this.ram[55256 + i] = this.ram[55296 + i];
            ++i;
        }
        i = 960;
        while (i < 1000) {
            this.ram[1024 + i] = 32;
            this.ram[55296 + i] = this.bgColor;
            ++i;
        }
        this.updateScreen();
    }

    private void clearScreen() {
        int i = 0;
        while (i < 1000) {
            this.ram[1024 + i] = 32;
            this.ram[55296 + i] = this.color;
            ++i;
        }
        this.ram[53281] = this.bgColor;
        this.ram[646] = this.color;
        this.clearRect(0, 0, this.width, this.height, this.bgColor);
        this.setCursor(0, 0);
        this.update();
    }

    private int getTextRamPos() {
        return 1024 + this.cursorX + 40 * this.cursorY;
    }

    private void removeFromMap() {
        ArrayList<Machine> keys = new ArrayList<Machine>();
        for (Map.Entry<Machine, ConsoleDevice> entry : machine2window.entrySet()) {
            if (entry.getValue() != this) continue;
            keys.add(entry.getKey());
            this.close();
        }
        for (Machine machine : keys) {
            machine2window.remove(machine);
            machine.setMemoryListener(this.oldMemoryListener);
            machine.setSystemCallListener(this.oldSystemCallListener);
            machine.setOutputChannel(this.oldOutputChannel);
            machine.setInputProvider(this.oldInputProvider);
        }
    }

    private void close() {
        this.gscreen.dispose();
        this.frame.setVisible(false);
        this.frame.dispose();
    }

    private void print(String txt, boolean newLine) {
        int col = this.ram[646] % 255;
        int i = 0;
        while (i < txt.length()) {
            char c = txt.charAt(i);
            switch (c) {
                case '\u0093': {
                    this.clearScreen();
                    this.setCursor(0, 0);
                    break;
                }
                case '\u0013': {
                    this.setCursor(0, 0);
                    break;
                }
                case '\u001d': {
                    this.setCursor(this.cursorX + 1, this.cursorY);
                    break;
                }
                case '\u009d': {
                    this.setCursor(this.cursorX - 1, this.cursorY);
                    break;
                }
                case '\u0011': {
                    this.setCursor(this.cursorX, this.cursorY + 1);
                    break;
                }
                case '\u0091': {
                    this.setCursor(this.cursorX, this.cursorY - 1);
                    break;
                }
                case '\u0090': {
                    col = 0;
                    break;
                }
                case '\u0005': {
                    col = 1;
                    break;
                }
                case '\u001c': {
                    col = 2;
                    break;
                }
                case '\u009f': {
                    col = 3;
                    break;
                }
                case '\u009c': {
                    col = 4;
                    break;
                }
                case '\u001e': {
                    col = 5;
                    break;
                }
                case '\u001f': {
                    col = 6;
                    break;
                }
                case '\u009e': {
                    col = 7;
                    break;
                }
                case '\u0081': {
                    col = 8;
                    break;
                }
                case '\u0095': {
                    col = 9;
                    break;
                }
                case '\u0096': {
                    col = 10;
                    break;
                }
                case '\u0097': {
                    col = 11;
                    break;
                }
                case '\u0098': {
                    col = 12;
                    break;
                }
                case '\u0099': {
                    col = 13;
                    break;
                }
                case '\u009a': {
                    col = 14;
                    break;
                }
                case '\u009b': {
                    col = 15;
                    break;
                }
                case '\u0012': {
                    this.reverseMode = true;
                    break;
                }
                case '\u0092': {
                    this.reverseMode = false;
                    break;
                }
                case '\u0014': {
                    this.setCursor(this.cursorX - 1, this.cursorY);
                    this.clearAtCursor();
                    break;
                }
                case '\u0094': {
                    this.shiftRight();
                    this.clearAtCursor();
                    this.updateScreen();
                    break;
                }
                case '\r': {
                    this.reverseMode = false;
                    this.setCursor(0, this.cursorY + 1);
                    break;
                }
                case ' ': {
                    if (this.reverseMode) {
                        this.setAtCursor();
                    } else {
                        this.clearAtCursor();
                    }
                    this.setCursor(this.cursorX + 1, this.cursorY);
                    break;
                }
                case '\u000e': {
                    this.setCharset(false);
                    break;
                }
                case '\u008e': {
                    this.setCharset(true);
                    break;
                }
                default: {
                    this.printChar(c);
                }
            }
            this.ram[646] = col;
            ++i;
        }
        if (newLine) {
            this.reverseMode = false;
            this.setCursor(0, this.cursorY + 1);
        }
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shiftRight() {
        ConsoleDevice consoleDevice = this;
        synchronized (consoleDevice) {
            int end;
            int offset;
            block5: {
                offset = this.cursorY * 40 + this.cursorX;
                end = this.cursorY * 40 + ((this.cursorY & 1) == 1 ? 39 : 79);
                if (this.ram[1024 + end] == 32) break block5;
                return false;
            }
            int i = end;
            while (i > offset) {
                this.ram[1024 + i] = this.ram[1024 + i - 1];
                this.ram[55296 + i] = this.ram[55296 + i - 1];
                --i;
            }
            this.pokeValue(1024 + offset, 32, 1024);
            this.pokeValue(55296 + offset, this.color, 55296);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shiftLeft() {
        ConsoleDevice consoleDevice = this;
        synchronized (consoleDevice) {
            int offset = this.cursorY * 40;
            int i = this.cursorX + offset;
            while (i < ((this.cursorY & 1) == 1 ? 39 : 79) + offset) {
                this.ram[1024 + i] = this.ram[1024 + i + 1];
                this.ram[55296 + i] = this.ram[55296 + i + 1];
                ++i;
            }
            this.pokeValue(1024 + i, 32, 1024);
            this.pokeValue(55296 + i, this.color, 55296);
        }
    }

    private void clearAtCursor() {
        int cw = this.width / 40;
        int y = this.cursorY * 40 * cw;
        int x = this.cursorX * cw;
        int pos = this.getTextRamPos() - 1024;
        this.clearRect(x, y, x + cw, y + cw, this.bgColor);
        this.pokeValue(1024 + pos, 32, 1024);
        this.pokeValue(55296 + pos, this.color, 55296);
    }

    private void setAtCursor() {
        int cw = this.width / 40;
        int y = this.cursorY * 40 * cw;
        int x = this.cursorX * cw;
        int pos = this.getTextRamPos() - 1024;
        this.clearRect(x, y, x + cw, y + cw, this.color);
        this.pokeValue(1024 + pos, 160, 1024);
        this.pokeValue(55296 + pos, this.color, 55296);
    }

    private class FontToggler
    implements KeyListener {
        private boolean pressed = false;

        private FontToggler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.isControlDown() && e.isShiftDown() && !this.pressed) {
                ConsoleDevice.this.toggleFontMode();
                this.pressed = true;
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.pressed = false;
        }
    }
}

