/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.extensions.x16.commands;

import com.sixtyfour.Logger;
import com.sixtyfour.cbmnative.NativeCompiler;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.commands.AbstractCommand;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.BasicProgramCounter;
import com.sixtyfour.system.Machine;
import java.util.ArrayList;
import java.util.List;

public class Color
extends AbstractCommand {
    public Color() {
        super("COLOR");
    }

    @Override
    public String parse(CompilerConfig config, String linePart, int lineCnt, int lineNumber, int linePos, boolean lastPos, Machine machine) {
        super.parse(config, linePart, lineCnt, lineNumber, linePos, lastPos, machine);
        this.term = Parser.getTerm(config, this, linePart, machine, true);
        List<Atom> pars = Parser.getParameters(this.term);
        if (pars.size() < 1 || pars.size() > 2) {
            this.syntaxError(linePart);
        }
        this.checkTypes(pars, linePart, Type.STRING, Type.STRING);
        return null;
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        List<Atom> pars = Parser.getParameters(this.term);
        Atom fg = pars.get(0);
        NativeCompiler compiler = NativeCompiler.getCompiler();
        ArrayList<String> before = new ArrayList<String>();
        ArrayList<String> after = new ArrayList<String>();
        ArrayList<String> expr = new ArrayList<String>();
        expr.addAll(compiler.compileToPseudoCode(config, machine, fg));
        if (pars.size() == 2) {
            expr.addAll(compiler.compileToPseudoCode(config, machine, pars.get(1)));
            after.add("POP Y");
            after.add("POP X");
            after.add("JSR TEXTBGCOLOR");
        } else {
            after.add("POP X");
            after.add("JSR TEXTCOLOR");
        }
        CodeContainer cc = new CodeContainer(before, expr, after);
        ArrayList<CodeContainer> ccs = new ArrayList<CodeContainer>();
        ccs.add(cc);
        return ccs;
    }

    @Override
    public BasicProgramCounter execute(CompilerConfig config, Machine machine) {
        Logger.log("Call to COLOR ignored by local runtime!");
        return null;
    }
}

