/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.extensions.x16.commands;

import com.sixtyfour.Logger;
import com.sixtyfour.cbmnative.NativeCompiler;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.commands.AbstractCommand;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.parser.TermEnhancer;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.BasicProgramCounter;
import com.sixtyfour.system.Machine;
import java.util.ArrayList;
import java.util.List;

public class Dos
extends AbstractCommand {
    private boolean command = false;
    private boolean status = false;

    public Dos() {
        super("DOS");
    }

    @Override
    public String parse(CompilerConfig config, String linePart, int lineCnt, int lineNumber, int linePos, boolean lastPos, Machine machine) {
        super.parse(config, linePart, lineCnt, lineNumber, linePos, lastPos, machine);
        linePart = TermEnhancer.removeWhiteSpace(linePart);
        linePart = linePart.substring(this.name.length());
        if (linePart.trim().isEmpty()) {
            linePart = "\"\"";
        }
        this.term = Parser.getTerm(config, linePart, machine, false, true);
        List<Atom> pars = Parser.getParameters(this.term);
        if (pars.size() > 1) {
            this.syntaxError(this);
        }
        if (pars.size() > 0 && !pars.get(0).getType().equals((Object)Type.STRING)) {
            this.syntaxError(this);
        }
        if (pars.size() == 0 || pars.get(0).isConstant() && ((String)pars.get(0).eval(machine)).isEmpty()) {
            this.status = true;
        } else {
            this.command = true;
        }
        return null;
    }

    @Override
    public BasicProgramCounter execute(CompilerConfig config, Machine machine) {
        Logger.log("Call to DOS ignored by local runtime!");
        return null;
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        NativeCompiler compiler = NativeCompiler.getCompiler();
        ArrayList<String> after = new ArrayList<String>();
        ArrayList<String> expr = new ArrayList<String>();
        ArrayList<String> before = new ArrayList<String>();
        try {
            if (this.command) {
                List<Atom> pars = Parser.getParameters(this.term);
                expr.addAll(compiler.compileToPseudoCode(config, machine, pars.get(0)));
                expr.add("POP G");
                after.add("JSR DOSCALL");
            } else if (this.status) {
                after.add("JSR DOSSTAT");
            } else {
                this.syntaxError(this);
            }
        }
        catch (ClassCastException e) {
            this.syntaxError(this);
        }
        CodeContainer cc = new CodeContainer(before, expr, after);
        ArrayList<CodeContainer> ccs = new ArrayList<CodeContainer>();
        ccs.add(cc);
        return ccs;
    }
}

