/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.extensions.x16.commands;

import com.sixtyfour.Logger;
import com.sixtyfour.cbmnative.NativeCompiler;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.commands.AbstractCommand;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.BasicProgramCounter;
import com.sixtyfour.system.Machine;
import java.util.ArrayList;
import java.util.List;

public class Pset
extends AbstractCommand {
    public Pset() {
        super("PSET");
    }

    @Override
    public String parse(CompilerConfig config, String linePart, int lineCnt, int lineNumber, int linePos, boolean lastPos, Machine machine) {
        super.parse(config, linePart, lineCnt, lineNumber, linePos, lastPos, machine);
        this.term = Parser.getTerm(config, this, linePart, machine, true);
        List<Atom> pars = Parser.getParameters(this.term);
        if (pars.size() < 2 || pars.size() > 3) {
            this.syntaxError(linePart);
        }
        this.checkTypes(pars, linePart, Type.STRING, Type.STRING, Type.STRING);
        return null;
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        List<Atom> pars = Parser.getParameters(this.term);
        Atom xc = pars.get(0);
        Atom yc = pars.get(1);
        NativeCompiler compiler = NativeCompiler.getCompiler();
        ArrayList<String> before = new ArrayList<String>();
        ArrayList<String> after = new ArrayList<String>();
        ArrayList<String> expr = new ArrayList<String>();
        expr.addAll(compiler.compileToPseudoCode(config, machine, xc));
        expr.addAll(compiler.compileToPseudoCode(config, machine, yc));
        if (pars.size() == 3) {
            expr.addAll(compiler.compileToPseudoCode(config, machine, pars.get(2)));
            after.add("POP C");
        } else {
            after.add("MOV C,#0{REAL}");
        }
        after.add("POP Y");
        after.add("POP X");
        after.add("JSR PLOT");
        CodeContainer cc = new CodeContainer(before, expr, after);
        ArrayList<CodeContainer> ccs = new ArrayList<CodeContainer>();
        ccs.add(cc);
        return ccs;
    }

    @Override
    public BasicProgramCounter execute(CompilerConfig config, Machine machine) {
        Logger.log("Call to PSET ignored by local runtime!");
        return null;
    }
}

