/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.extensions.x16.commands;

import com.sixtyfour.cbmnative.NativeCompiler;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.commands.FileOperation;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.plugins.DeviceProvider;
import com.sixtyfour.system.BasicProgramCounter;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.ArrayList;
import java.util.List;

public class Vload
extends FileOperation {
    public Vload() {
        super("VLOAD");
    }

    @Override
    protected boolean isLoad() {
        return true;
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        NativeCompiler compiler = NativeCompiler.getCompiler();
        ArrayList<String> after = new ArrayList<String>();
        ArrayList<String> expr = new ArrayList<String>();
        ArrayList<String> before = new ArrayList<String>();
        List<Atom> pars = Parser.getParameters(this.term);
        try {
            switch (pars.size()) {
                case 4: {
                    expr.addAll(compiler.compileToPseudoCode(config, machine, pars.get(0)));
                    expr.addAll(compiler.compileToPseudoCode(config, machine, pars.get(1)));
                    expr.addAll(compiler.compileToPseudoCode(config, machine, pars.get(2)));
                    expr.addAll(compiler.compileToPseudoCode(config, machine, pars.get(3)));
                    expr.add("POP C");
                    expr.add("POP Y");
                    expr.add("POP X");
                    expr.add("POP G");
                    break;
                }
                default: {
                    this.syntaxError(this);
                    break;
                }
            }
        }
        catch (ClassCastException e) {
            this.syntaxError(this);
        }
        after.add("JSR VLOAD");
        CodeContainer cc = new CodeContainer(before, expr, after);
        ArrayList<CodeContainer> ccs = new ArrayList<CodeContainer>();
        ccs.add(cc);
        return ccs;
    }

    @Override
    public BasicProgramCounter execute(CompilerConfig config, Machine machine) {
        DeviceProvider device = machine.getDeviceProvider();
        List<Atom> pars = Parser.getParameters(this.term);
        try {
            switch (pars.size()) {
                case 4: {
                    device.load(config, (String)pars.get(0).eval(machine), VarUtils.getInt(pars.get(1).eval(machine)), VarUtils.getInt(pars.get(2).eval(machine)));
                    break;
                }
                default: {
                    this.syntaxError(this);
                    break;
                }
            }
        }
        catch (ClassCastException e) {
            this.syntaxError(this);
        }
        return null;
    }
}

