/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.extensions.x16.commands;

import com.sixtyfour.cbmnative.NativeCompiler;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.Variable;
import com.sixtyfour.elements.commands.AbstractCommand;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.parser.Term;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.BasicProgramCounter;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.ArrayList;
import java.util.List;

public class Vpoke
extends AbstractCommand {
    protected Atom addr = null;
    protected Atom val = null;
    private Atom bank = null;

    public Vpoke() {
        super("VPOKE");
    }

    @Override
    public String parse(CompilerConfig config, String linePart, int lineCnt, int lineNumber, int linePos, boolean lastPos, Machine machine) {
        super.parse(config, linePart, lineCnt, lineNumber, linePos, lastPos, machine);
        this.term = Parser.getTerm(config, this, linePart, machine, true);
        List<Atom> pars = Parser.getParameters(this.term);
        if (pars.size() != 3) {
            this.syntaxError(this);
        }
        this.checkTypes(pars, linePart, Type.STRING, Type.STRING, Type.STRING);
        this.bank = pars.get(0);
        this.addr = pars.get(1);
        this.val = pars.get(2);
        if (this.val instanceof Variable) {
            this.val = new Term(this.val);
        }
        if (this.bank instanceof Variable) {
            this.bank = new Term(this.bank);
        }
        if (this.addr instanceof Variable) {
            this.addr = new Term(this.addr);
        }
        return null;
    }

    @Override
    public BasicProgramCounter execute(CompilerConfig config, Machine machine) {
        int memAddr = VarUtils.getInt(this.addr.eval(machine));
        int vally = VarUtils.getInt(this.val.eval(machine));
        if (vally < 0 || vally > 255 || memAddr < 0 || memAddr > 65535) {
            throw new RuntimeException("Illegal quantity error: " + this + "/" + vally + "/" + memAddr);
        }
        machine.getRam()[memAddr] = vally;
        machine.getMemoryListener().poke(memAddr, vally);
        return null;
    }

    @Override
    public List<Term> getAllTerms() {
        ArrayList<Term> ret = new ArrayList<Term>();
        if (this.addr.isTerm()) {
            ret.add((Term)this.addr);
        }
        if (this.val.isTerm()) {
            ret.add((Term)this.val);
        }
        if (this.bank.isTerm()) {
            ret.add((Term)this.bank);
        }
        return ret;
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        NativeCompiler compiler = NativeCompiler.getCompiler();
        ArrayList<String> after = new ArrayList<String>();
        List<Object> expr = new ArrayList();
        String expPush = "";
        int valConst = -1;
        boolean cValFlag = false;
        if (this.val.isConstant()) {
            valConst = ((Number)this.val.eval(machine)).intValue();
            valConst &= 0xFF;
            cValFlag = true;
        } else {
            expr = compiler.compileToPseudoCode(config, machine, this.val);
            expPush = this.getPushRegister((String)expr.get(expr.size() - 1));
            expr = expr.subList(0, expr.size() - 1);
        }
        ArrayList<String> before = new ArrayList();
        List<String> bankSwitch = compiler.compileToPseudoCode(config, machine, this.bank);
        String bankPush = this.getPushRegister(bankSwitch.get(bankSwitch.size() - 1));
        bankSwitch = bankSwitch.subList(0, bankSwitch.size() - 1);
        if (this.addr.isConstant()) {
            if (expPush.equals("Y")) {
                expr.add("MOV X,Y");
            }
            int addi = ((Number)this.addr.eval(machine)).intValue();
            int lo = addi & 0xFF;
            int hi = addi >> 8;
            after.add("MOVB VERALO,#" + lo + "{INTEGER}");
            after.add("MOVB VERAMID,#" + hi + "{INTEGER}");
            if (cValFlag) {
                after.add("MOVB VERADAT,#" + valConst + "{INTEGER}");
            } else {
                after.add("MOVB VERADAT,X");
            }
        } else {
            before = compiler.compileToPseudoCode(config, machine, this.addr);
            if (expPush.equals("Y")) {
                expr.add("MOV X,Y");
            }
            after.add("POP Y");
            after.add("MOVB VERALO:VERAMID,Y");
            if (cValFlag) {
                after.add("MOVB VERADAT,#" + valConst + "{INTEGER}");
            } else {
                after.add("MOVB VERADAT,X");
            }
        }
        this.addBankSwitchingCode(machine, before, after, bankSwitch, bankPush);
        CodeContainer cc = new CodeContainer(before, expr, after);
        ArrayList<CodeContainer> ccs = new ArrayList<CodeContainer>();
        ccs.add(cc);
        return ccs;
    }

    private void addBankSwitchingCode(Machine machine, List<String> before, List<String> after, List<String> bankSwitch, String bankPush) {
        if (this.bank.isConstant()) {
            before.add("MOVB VERAHI,#" + ((Number)this.bank.eval(machine)).intValue() + "{INTEGER}");
        } else {
            if (bankPush.equals("Y")) {
                bankSwitch.add("MOV X,Y");
            }
            bankSwitch.add("MOVB VERAHI,X");
            before.addAll(0, bankSwitch);
        }
    }
}

