/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.extensions.x16.functions;

import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.functions.AbstractFunction;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class Vpeek
extends AbstractFunction {
    public Vpeek() {
        super("VPEEK");
    }

    @Override
    public Type getType() {
        return this.term.getType();
    }

    @Override
    public Object eval(Machine machine) {
        if (!this.getType().equals((Object)Type.STRING)) {
            int addr = VarUtils.getInt(this.term.eval(machine));
            int peeked = Integer.valueOf(machine.getRam()[addr]) & 0xFF;
            Integer peekedAsWell = machine.getMemoryListener().peek(addr);
            if (peekedAsWell != null) {
                peeked = peekedAsWell & 0xFF;
            }
            return peeked;
        }
        throw new RuntimeException("Type mismatch error: " + (Object)((Object)this.getType()));
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        List<Atom> pars = Parser.getParameters(this.term);
        if (pars.size() != 2) {
            throw new RuntimeException("Wrong number of parameters: " + this.term);
        }
        Atom var = pars.get(1);
        ArrayList<String> ret = new ArrayList<String>();
        List<String> n1 = pars.get(0).evalToCode(config, machine).get(0).getExpression();
        n1.add(":PAR");
        n1.add("_");
        n1.addAll(var.evalToCode(config, machine).get(0).getExpression());
        n1.add(":" + this.getClass().getSimpleName().toUpperCase(Locale.ENGLISH));
        ret.addAll(0, n1);
        ret.add("_");
        ArrayList<CodeContainer> cc = new ArrayList<CodeContainer>();
        cc.add(new CodeContainer(ret));
        return cc;
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    @Override
    public int getParameterCount() {
        return 2;
    }

    @Override
    public boolean addNativeFunctionCall(List<String> code) {
        code.add("POP C");
        code.add("JSR VPEEK");
        return true;
    }
}

