/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.extensions.x16.systemvars;

import com.sixtyfour.elements.Variable;
import com.sixtyfour.system.Machine;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateX
extends Variable {
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
    private long initTime = 0L;
    private long setTime = 0L;

    public DateX() {
        super("DA$", "20200101");
        this.setSystem(true);
    }

    @Override
    public Object getValue() {
        return this.sdf.format(this.getIntervalValue());
    }

    public Date getIntervalValue() {
        long now = System.currentTimeMillis();
        long dif = now - this.setTime;
        long add = this.initTime + dif;
        return new Date(add);
    }

    @Override
    public Object eval(Machine machine) {
        return this.getValue();
    }

    @Override
    public void setValue(Object value) {
        super.setValue(value);
        if (value == null || value.toString().isEmpty()) {
            return;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            String val = value.toString();
            if (val.length() != 8) {
                throw new RuntimeException();
            }
            Date date = sdf.parse(val);
            this.initTime = date.getTime();
            this.setTime = System.currentTimeMillis();
        }
        catch (Exception e) {
            throw new RuntimeException("Illegal quantity error: " + value);
        }
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }
}

