/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.parser;

import com.sixtyfour.elements.commands.Command;
import java.util.ArrayList;
import java.util.List;

public class Line {
    private String line;
    private int number;
    private int count;
    private List<Command> commands = new ArrayList<Command>();

    public Line(int number, String line) {
        this.line = line;
        this.number = number;
    }

    public static Line getLine(String line) {
        int i = 0;
        while (i < line.length()) {
            char c = line.charAt(i);
            if (!Character.isDigit(c)) {
                return new Line(Integer.parseInt(line.substring(0, i)), line.substring(i).trim());
            }
            ++i;
        }
        throw new RuntimeException("No command found in: " + line);
    }

    public void addDummyRemark() {
        boolean inString = false;
        int i = 0;
        while (i < this.line.length()) {
            char c = this.line.charAt(i);
            if (c == '\"') {
                inString = !inString;
            }
            ++i;
        }
        if (!inString) {
            this.line = String.valueOf(this.line) + "REM";
        }
    }

    public String getLine() {
        return this.line;
    }

    public int getNumber() {
        return this.number;
    }

    public void addCommand(Command command) {
        this.commands.add(command);
    }

    public List<Command> getCommands() {
        return this.commands;
    }

    public <T extends Command> T getAnyCommand(Class<T> clazz) {
        for (Command command : this.commands) {
            if (!command.getClass().isAssignableFrom(clazz)) continue;
            return (T)command;
        }
        return null;
    }

    public <T extends Command> T getFirstCommand() {
        Command firstCommand = this.commands.get(0);
        return (T)firstCommand;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public String toString() {
        return String.valueOf(this.number) + " " + this.line;
    }

    public void setLine(String line) {
        this.line = line;
    }
}

