/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.parser;

public class Operator {
    private static final String[] OPS = new String[]{"^", "*", "/", "+", "-", "|", ",", "\u00b0", "&", "!", "<", ">", "="};
    private int type = -1;
    public static final Operator NOP = new Operator('|');

    public Operator(String op) {
        op = op.trim();
        int cnt = 0;
        String[] stringArray = OPS;
        int n = OPS.length;
        int n2 = 0;
        while (n2 < n) {
            String o = stringArray[n2];
            if (o.equals(op)) {
                this.setType(cnt);
            }
            ++cnt;
            ++n2;
        }
        if (this.type == -1) {
            throw new RuntimeException("Unsupported operator: " + op);
        }
    }

    public Operator(char c) {
        this(Character.toString(c));
    }

    public static String getOrOperator() {
        return OPS[7];
    }

    public static String getAndOperator() {
        return OPS[8];
    }

    public static String getNotOperator() {
        return OPS[9];
    }

    public boolean isOr() {
        return this.type == 7;
    }

    public boolean isAnd() {
        return this.type == 8;
    }

    public boolean isNot() {
        return this.type == 9;
    }

    public boolean isPlus() {
        return this.type == 3;
    }

    public boolean isPower() {
        return this.type == 0;
    }

    public boolean isMinus() {
        return this.type == 4;
    }

    public boolean isMultiplication() {
        return this.type == 1;
    }

    public boolean isDivision() {
        return this.type == 2;
    }

    public boolean isDelimiter() {
        return this.type == 6;
    }

    public boolean isNop() {
        return this.type == 5;
    }

    public boolean isMathOperation() {
        return this.isPlus() || this.isPower() || this.isMinus() || this.isMultiplication() || this.isDivision();
    }

    public static boolean isOperator(char c) {
        String[] stringArray = OPS;
        int n = OPS.length;
        int n2 = 0;
        while (n2 < n) {
            String op = stringArray[n2];
            if (op.charAt(0) == c) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isLogicOperator(char c) {
        return c == '&' || c == '\u00b0';
    }

    public static boolean isRealOperator(char c) {
        if (c == ',' || c == '|') {
            return false;
        }
        String[] stringArray = OPS;
        int n = OPS.length;
        int n2 = 0;
        while (n2 < n) {
            String op = stringArray[n2];
            if (op.charAt(0) == c) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isComparisonOperator(char c) {
        return c == '<' || c == '>' || c == '=';
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String toString() {
        return OPS[this.type];
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Operator) {
            if (o == this) {
                return true;
            }
            return this.getType() == ((Operator)o).getType();
        }
        return false;
    }

    public int hashCode() {
        return Integer.valueOf(this.getType()).hashCode();
    }
}

