/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.parser;

import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Constant;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.Variable;
import com.sixtyfour.elements.commands.Command;
import com.sixtyfour.elements.commands.CommandList;
import com.sixtyfour.elements.functions.ArrayAccess;
import com.sixtyfour.elements.functions.Function;
import com.sixtyfour.elements.functions.FunctionList;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Line;
import com.sixtyfour.parser.Operator;
import com.sixtyfour.parser.Term;
import com.sixtyfour.parser.TermBuilder;
import com.sixtyfour.parser.TermEnhancer;
import com.sixtyfour.parser.VariableAndIndex;
import com.sixtyfour.parser.VariableAndTerms;
import com.sixtyfour.parser.logic.LogicParser;
import com.sixtyfour.parser.logic.LogicTerm;
import com.sixtyfour.parser.optimize.ConstantFolder;
import com.sixtyfour.parser.optimize.TermOptimizer;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.Checker;
import com.sixtyfour.util.VarUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Parser {
    private static TermBuilder builder = new TermBuilder(){

        @Override
        public Term build(CompilerConfig config, Term t, Map<String, Term> termMap, Machine machine) {
            return Parser.build(config, t, termMap, machine);
        }
    };
    private static boolean optimizeConstantExpressions = true;

    public static void setOptimizeConstantExpressions(boolean optimizeConstantExpressions) {
        Parser.optimizeConstantExpressions = optimizeConstantExpressions;
    }

    public static String[] getParts(Line line, Machine machine) {
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean inString = false;
        String term = line.getLine();
        int i = 0;
        while (i < term.length()) {
            char c = term.charAt(i);
            if (c == '\"') {
                boolean bl = inString = !inString;
            }
            if (inString || c != ':') {
                sb.append(c);
            }
            if (!inString && c == ':') {
                parts.add(Parser.cleanPart(sb));
                sb.setLength(0);
            }
            ++i;
        }
        if (sb.length() > 0) {
            parts.add(Parser.cleanPart(sb));
        }
        return parts.toArray(new String[parts.size()]);
    }

    public static boolean isInteger(String txt) {
        try {
            Integer.parseInt(txt);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static Command getCommand(String linePart) {
        List<Command> commands = CommandList.getCommands();
        Command com = null;
        String linePartWoS = TermEnhancer.removeWhiteSpace(linePart);
        for (Command command : commands) {
            String tmp = linePart;
            if (!command.keepSpaces()) {
                tmp = linePartWoS;
            }
            if (!command.isCommand(tmp)) continue;
            com = command.cloneCommand();
            break;
        }
        if (com == null && linePart.contains("=")) {
            com = CommandList.getLetCommand().cloneCommand();
        }
        return com;
    }

    public static Variable getVariable(String linePart, Machine machine) {
        return Parser.getVariable(linePart, machine, true);
    }

    public static Variable getVariable(String linePart, Machine machine, boolean includingAssignment) {
        String ret = Parser.extractName(linePart, includingAssignment);
        if (!ret.endsWith("[]")) {
            Variable var = new Variable(ret, null);
            if (machine.isSystemVariable(var.getUpperCaseName())) {
                var.setSystem(true);
            }
            return machine.add(var);
        }
        return new Variable(ret, null);
    }

    public static boolean hasVariableAdded(String linePart, Machine machine, boolean includingAssignment) {
        String ret = Parser.extractName(linePart, includingAssignment);
        return machine.getVariable(ret) != null;
    }

    public static List<VariableAndTerms> getArrayVariables(CompilerConfig config, String linePart, Machine machine) {
        String[] parts;
        if (!linePart.contains("(") && !linePart.contains(")")) {
            return null;
        }
        ArrayList<VariableAndTerms> vars = new ArrayList<VariableAndTerms>();
        linePart = linePart.substring(3).trim();
        StringBuilder sb = new StringBuilder();
        int brackets = 0;
        int i = 0;
        while (i < linePart.length()) {
            char c = linePart.charAt(i);
            if (c == '(') {
                ++brackets;
            }
            if (c == ')') {
                --brackets;
            }
            if (c == ',' && brackets == 0) {
                sb.append(';');
            } else {
                sb.append(c);
            }
            ++i;
        }
        linePart = sb.toString();
        String[] stringArray = parts = linePart.split(";");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            List<Atom> pars;
            String var;
            String part = stringArray[n2];
            if (!(part = part.trim()).endsWith(")")) {
                part = String.valueOf(part) + "(10)";
            }
            int pos = part.indexOf(40);
            int pos2 = part.lastIndexOf(41);
            if (pos != -1 && pos2 != -1) {
                var = VarUtils.toUpper(part.substring(0, pos).trim());
                Term params = Parser.getTerm(config, part.substring(pos + 1, pos2), machine, false, true);
                pars = Parser.getParameters(params);
                if (pars.size() == 0) {
                    throw new RuntimeException("No array size specified: " + part + "/" + params);
                }
            } else {
                throw new RuntimeException("Syntax error: " + linePart);
            }
            VariableAndTerms vat = new VariableAndTerms(var, pars);
            vars.add(vat);
            ++n2;
        }
        return vars;
    }

    public static String getVariableName(String linePart) {
        char c;
        linePart = VarUtils.toUpper(linePart.trim());
        int pos = linePart.indexOf(40);
        boolean isArray = false;
        if (pos != -1) {
            linePart = linePart.substring(0, pos);
            isArray = true;
        }
        int i = 0;
        while (i < linePart.length()) {
            c = linePart.charAt(i);
            if (i == 0 && !Character.isLetter(c)) {
                throw new RuntimeException("Invalid variable name: " + linePart);
            }
            if (!Character.isLetter(c) && i > 0 && !Character.isDigit(c) && c != '%' && c != '$') {
                throw new RuntimeException("Invalid variable name: " + linePart);
            }
            if ((c == '%' || c == '$') && i != linePart.length() - 1) {
                throw new RuntimeException("Invalid variable name: " + linePart);
            }
            ++i;
        }
        String ret = "";
        if (linePart.length() > 0) {
            c = linePart.charAt(linePart.length() - 1);
            ret = linePart.substring(0, Math.min(2, linePart.length()));
            if (!(c != '%' && c != '$' || ret.endsWith(Character.toString(c)))) {
                ret = String.valueOf(ret) + c;
            }
        }
        if (isArray && !ret.endsWith("[]")) {
            ret = String.valueOf(ret) + "[]";
        }
        return ret;
    }

    public static String replaceStrings(String term, char toReplaceWith) {
        StringBuilder sb = new StringBuilder();
        boolean inString = false;
        int i = 0;
        while (i < term.length()) {
            char c = term.charAt(i);
            if (c == '\"') {
                inString = !inString;
                sb.append('\"');
            } else if (!inString) {
                sb.append(c);
            } else {
                sb.append(toReplaceWith);
            }
            ++i;
        }
        return VarUtils.toUpper(sb.toString());
    }

    public static VariableAndIndex getIndexTerm(CompilerConfig config, Variable var, String linePart, Machine machine, boolean checkForAssignment) {
        if (var.getName().endsWith("[]")) {
            int pos;
            if (checkForAssignment && (pos = linePart.indexOf(61)) != -1) {
                linePart = linePart.substring(0, pos);
            }
            pos = linePart.indexOf(40);
            int pos2 = linePart.lastIndexOf(41);
            if (pos != -1 && pos2 != -1) {
                boolean dimed;
                Term params = Parser.getTerm(config, linePart.substring(pos + 1, pos2), machine, false, true);
                List<Atom> pars = Parser.getParameters(params);
                boolean bl = dimed = machine.getVariable(var.getName()) != null;
                if (!dimed) {
                    int[] pis = new int[pars.size()];
                    int i = 0;
                    while (i < pis.length) {
                        pis[i] = 10;
                        ++i;
                    }
                    var = new Variable(var.getName(), null, pis);
                    var.clear();
                }
                return new VariableAndIndex(var, params);
            }
            throw new RuntimeException("Array index out of bounds error: " + linePart);
        }
        return new VariableAndIndex(var, null);
    }

    public static Function getArrayAccessFunction(CompilerConfig config, String linePart, Variable var, Map<String, Term> termMap, Machine machine) {
        ArrayAccess fun = new ArrayAccess();
        int pos = linePart.indexOf(40);
        int pos2 = linePart.lastIndexOf(41);
        if (pos == -1 || pos2 < pos) {
            pos = linePart.indexOf(123);
            pos2 = linePart.indexOf(125);
            if (termMap == null || pos == -1 || pos2 < pos) {
                throw new RuntimeException("Invalid function call: " + linePart);
            }
            fun.setTerm(Parser.createTerm(config, linePart.substring(pos, pos2 + 1), termMap, machine));
        } else {
            fun.parse(config, linePart.substring(pos + 1, pos2), machine);
        }
        fun.setVariable(var);
        return fun;
    }

    public static Term getTerm(CompilerConfig config, String term, Machine machine, boolean stripAssignment, boolean checkForLogicTerm) {
        Parser.checkForInvalidChars(term);
        Term ret = Parser.getTerm(config, term, machine, stripAssignment, checkForLogicTerm, null);
        ret.setInitial(TermEnhancer.stripAssignment(term, stripAssignment));
        return ret;
    }

    public static Term getTermWithoutChecks(CompilerConfig config, String term, Machine machine, boolean stripAssignment, boolean checkForLogicTerm) {
        Term ret = Parser.getTerm(config, term, machine, stripAssignment, checkForLogicTerm, null);
        ret.setInitial(TermEnhancer.stripAssignment(term, stripAssignment));
        return ret;
    }

    public static Term getTerm(CompilerConfig config, String term, Machine machine, boolean stripAssignment, boolean checkForLogicTerm, Map<String, Term> termMap) {
        if (termMap == null) {
            termMap = new HashMap<String, Term>();
        }
        term = TermEnhancer.stripAssignment(term, stripAssignment);
        term = TermEnhancer.replaceScientificNotation(term);
        term = TermEnhancer.handleNonDecimalNumbers(config, term);
        term = TermEnhancer.addBrackets(term);
        Term ret = Parser.createTerms(config, term, termMap, machine, checkForLogicTerm);
        if (optimizeConstantExpressions) {
            ret = TermOptimizer.optimizeTerm(config, machine, ret, termMap, builder);
        }
        ret.setInitial(term, termMap);
        return ret;
    }

    public static Term getTerm(CompilerConfig config, Command command, String term, Machine machine, boolean checkForLogicTerm) {
        Parser.checkForInvalidChars(term);
        term = TermEnhancer.removeWhiteSpace(term.substring(command.getName().length()));
        term = TermEnhancer.replaceScientificNotation(term);
        term = TermEnhancer.handleNonDecimalNumbers(config, term);
        term = TermEnhancer.addBrackets(term);
        Term ret = Parser.createTerms(config, term, new HashMap<String, Term>(), machine, checkForLogicTerm);
        ret.setInitial(term);
        return ret;
    }

    public static Term createIndexTerm(CompilerConfig config, Machine machine, List<Atom> pars, int[] dimensions) {
        int m = 1;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < pars.size()) {
            if (sb.length() > 0) {
                sb.append("+");
            }
            if (pars.size() > 1) {
                sb.append("int(");
            } else {
                sb.append("(");
            }
            Atom atom = pars.get(i);
            if (!(atom instanceof Term)) {
                if (atom instanceof Variable) {
                    sb.append(((Variable)atom).getUpperCaseName());
                } else if (atom instanceof Function) {
                    Function fun = (Function)atom;
                    String call = fun.getInitialCall();
                    sb.append(call);
                } else {
                    sb.append(atom.eval(machine));
                }
            } else {
                String ini = ((Term)atom).getInitial();
                if (i == 0) {
                    ini = ((Term)atom).getTruncatedInitial();
                }
                sb.append(ini);
            }
            if (m == 1) {
                sb.append(")");
            } else {
                sb.append(")*(").append(m).append(")");
            }
            if (i >= dimensions.length) {
                throw new RuntimeException("Syntax error: Array index count out of range!");
            }
            m *= dimensions[i] + 1;
            ++i;
        }
        String newTerm = TermOptimizer.optimizeLinearIndexTerm(sb.toString());
        Term t = Parser.getTermWithoutChecks(config, newTerm, machine, false, true);
        return t;
    }

    public static String cleanStringConcats(String line) {
        if (!line.contains("\"") && !line.contains("$")) {
            return line;
        }
        if (line.startsWith("+")) {
            line = "\"\"" + line;
        }
        StringBuilder sb = new StringBuilder();
        boolean inString = false;
        int cnt = 0;
        int i = 0;
        while (i < line.length()) {
            char c = line.charAt(i);
            if (c == '\"') {
                boolean bl = inString = !inString;
            }
            if (!inString) {
                cnt = c == '+' ? ++cnt : 0;
                if (cnt <= 1) {
                    sb.append(c);
                }
            } else {
                sb.append(c);
                cnt = 0;
            }
            ++i;
        }
        return sb.toString();
    }

    public static List<Atom> getParameters(Term term) {
        ArrayList<Atom> results = new ArrayList<Atom>();
        if (term.getLeft() != null) {
            Parser.getParameters(term, results);
            if (results.size() == 0) {
                results.add(term);
            }
            Collections.reverse(results);
        }
        return results;
    }

    public static boolean isNumberType(Atom atom) {
        return atom.getType().equals((Object)Type.INTEGER) || atom.getType().equals((Object)Type.REAL);
    }

    public static boolean isFunction(String linePart) {
        List<Function> functions = FunctionList.getFunctions();
        for (Function function : functions) {
            if (!function.isFunction(linePart)) continue;
            return true;
        }
        return false;
    }

    private static void getParameters(Atom atom, List<Atom> results) {
        if (atom.isTerm()) {
            Term term = (Term)atom;
            boolean addLeft = Parser.toAdd(term.getLeft());
            boolean addRight = Parser.toAdd(term.getRight());
            if (term.getOperator().isDelimiter()) {
                if (addRight) {
                    results.add(term.getRight());
                }
                if (addLeft) {
                    results.add(term.getLeft());
                }
            }
            Parser.getParameters(term.getLeft(), results);
            Parser.getParameters(term.getRight(), results);
        }
    }

    private static boolean toAdd(Atom atom) {
        if (atom == null) {
            throw new RuntimeException("Parameter missing!");
        }
        return !atom.isTerm() || !((Term)atom).getOperator().isDelimiter();
    }

    private static Term createTerms(CompilerConfig config, String term, Map<String, Term> termMap, Machine machine, boolean checkForLogicTerm) {
        try {
            int start = 0;
            boolean open = false;
            boolean inString = false;
            int i = 0;
            while (i < term.length()) {
                char c = term.charAt(i);
                if (c == '\"') {
                    boolean bl = inString = !inString;
                }
                if (!inString || i == term.length() - 1) {
                    if (c == '(') {
                        open = true;
                        start = i;
                    }
                    if (c == ')') {
                        if (inString) {
                            c = '\"';
                            term = String.valueOf(term.substring(0, i)) + c + term.substring(i);
                            inString = false;
                        } else if (open) {
                            String sub = term.substring(start + 1, i);
                            boolean logic = checkForLogicTerm && LogicParser.isLogicTerm(sub);
                            Term res = null;
                            res = !logic ? Parser.createTerm(config, sub, termMap, machine) : Parser.createLogicTerm(config, sub, termMap, machine);
                            if (res != null) {
                                String termKey = null;
                                int index = termMap.size();
                                termKey = res.getKey() == null ? "{t" + index + "}" : res.getKey();
                                res.setKey(termKey);
                                termMap.put(termKey, res);
                                term = String.valueOf(term.substring(0, start)) + termKey + term.substring(i + 1);
                                if (term.equals(termKey)) break;
                            }
                            open = false;
                            i = -1;
                        } else {
                            throw new RuntimeException("Parse error in: " + term + "/" + start + "/" + i);
                        }
                    }
                }
                ++i;
            }
            Term finalTerm = new Term(term, termMap);
            termMap.put("final", finalTerm);
            finalTerm = Parser.build(config, finalTerm, termMap, machine);
            finalTerm.setKey("final");
            if (!finalTerm.isComplete()) {
                finalTerm.setOperator(Operator.NOP);
                finalTerm.setRight(new Constant<Integer>(0));
            }
            finalTerm = ConstantFolder.foldConstants(config, TermOptimizer.optimizeTermTree(finalTerm, machine), machine);
            return finalTerm;
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            throw new RuntimeException("Syntax error: " + term);
        }
    }

    private static Term createLogicTerm(CompilerConfig config, String term, Map<String, Term> termMap, Machine machine) {
        String termWoBrackets = term.replace("(", "").replace(")", "");
        if (Parser.isTermPlaceholder(termWoBrackets)) {
            return termMap.get(termWoBrackets);
        }
        String sterm = Parser.replaceStrings(term, '_');
        if (!sterm.contains("(") && !sterm.contains(")")) {
            Term t = new Term(term, termMap);
            LogicTerm logicTerm = LogicParser.getTerm(config, term, machine, termMap);
            t.setLeft(logicTerm);
            if (!t.isComplete()) {
                t.setOperator(Operator.NOP);
                t.setRight(new Constant<Integer>(0));
            }
            return t;
        }
        return null;
    }

    private static Term createTerm(CompilerConfig config, String term, Map<String, Term> termMap, Machine machine) {
        String termWoBrackets = term.replace("(", "").replace(")", "");
        if (Parser.isTermPlaceholder(termWoBrackets)) {
            return termMap.get(termWoBrackets);
        }
        String mTerm = Parser.replaceStrings(term, '.');
        if (!mTerm.contains("(") && !mTerm.contains(")")) {
            term = Parser.cleanStringConcats(term);
            Term t = new Term(term, termMap);
            if ((t = Parser.build(config, t, termMap, machine)).getOperator() != null && t.getOperator().isMathOperation() && t.getRight() == null) {
                throw new RuntimeException("Syntax error: " + term);
            }
            if (!t.isComplete()) {
                t.setOperator(Operator.NOP);
                t.setRight(new Constant<Integer>(0));
            }
            return t;
        }
        return null;
    }

    private static Term build(CompilerConfig config, Term t, Map<String, Term> termMap, Machine machine) {
        String exp = t.getExpression();
        StringBuilder part = new StringBuilder();
        char lastC = '(';
        boolean inString = false;
        int i = 0;
        while (i < exp.length()) {
            char c = exp.charAt(i);
            if (c == '\"') {
                inString = !inString;
            }
            boolean isOp = !inString && Operator.isOperator(c);
            boolean appended = false;
            if (!isOp || c == '-' && (lastC == '(' || Operator.isOperator(lastC))) {
                part.append(c);
                appended = true;
            }
            if (!appended || i >= exp.length() - 1) {
                Atom atom = Parser.createAtom(config, part.toString(), termMap, machine);
                part.setLength(0);
                if (t.getLeft() == null) {
                    t.setLeft(atom);
                } else if (t.getRight() == null) {
                    t.setRight(atom);
                }
            }
            if (isOp && !appended) {
                part.setLength(0);
                if (t.isComplete()) {
                    Term nt = new Term(t.getExpression(), termMap);
                    nt.setLeft(t);
                    t = nt;
                }
                t.setOperator(new Operator(c));
            }
            lastC = c;
            ++i;
        }
        Parser.checkTypeMismatch(t);
        return t;
    }

    private static void checkTypeMismatch(Term t) {
        if (t.getLeft() != null && t.getRight() != null && (t.getOperator().isAnd() || t.getOperator().isOr()) && Checker.isTypeMismatch(t)) {
            throw new RuntimeException("Type mismatch error: term:" + t + " --- left:" + t.getLeft() + " --- right:" + t.getRight());
        }
    }

    private static Atom createAtom(CompilerConfig config, String part, Map<String, Term> termMap, Machine machine) {
        Function function = Parser.getFunction(config, part, termMap, machine);
        String strippedPart = Parser.replaceStrings(part, ' ');
        Command command = Parser.getCommand(strippedPart);
        if (command != null && function == null) {
            throw new RuntimeException("Syntax error: " + part + "/" + command.getName());
        }
        if (function != null) {
            return function;
        }
        if (part.startsWith("\"")) {
            if (part.endsWith("\"")) {
                String ct = part.replaceAll("\"", "");
                Constant<String> str = new Constant<String>(ct);
                return str;
            }
            throw new RuntimeException("String not properly terminated: " + part);
        }
        if (part.endsWith("\"")) {
            throw new RuntimeException("String not open: " + part);
        }
        boolean number = true;
        boolean real = false;
        int i = 0;
        while (i < part.length()) {
            char c = part.charAt(i);
            if (!Character.isDigit(c) && c != '-' && c != '.') {
                number = false;
                break;
            }
            if (c == '.') {
                real = true;
            }
            ++i;
        }
        if (number) {
            if (real) {
                if (part.equals(".")) {
                    part = "0.0";
                }
                Constant<Double> fl = new Constant<Double>(Double.valueOf(part));
                return fl;
            }
            if (part.isEmpty()) {
                part = "0";
            }
            Constant<Number> in = null;
            try {
                in = new Constant<Integer>(Integer.valueOf(part));
            }
            catch (NumberFormatException nfe) {
                in = new Constant<Double>(Double.valueOf(part));
            }
            return in;
        }
        if (part.startsWith("{") && part.endsWith("}")) {
            Term t = termMap.get(part);
            if (t == null) {
                throw new RuntimeException("Unknown term: " + part);
            }
            if (!t.isComplete()) {
                t = Parser.build(config, t, termMap, machine);
            }
            return t;
        }
        if (Character.isLetter(part.charAt(0)) && (part.endsWith("}") || part.endsWith(")"))) {
            String var = VarUtils.toUpper(part);
            int pos = var.replace('{', '(').indexOf("(");
            if (pos == -1) {
                throw new RuntimeException("Invalid array index: " + part);
            }
            String pvar = String.valueOf(var.substring(0, pos)) + "[]";
            Variable vary = new Variable(pvar, null);
            return Parser.getArrayAccessFunction(config, part, vary, termMap, machine);
        }
        String var = VarUtils.toUpper(part);
        Variable vary = machine.getVariable(var);
        if (vary == null) {
            vary = new Variable(var, null);
            vary = machine.add(vary);
        }
        return vary;
    }

    private static boolean isTermPlaceholder(String txt) {
        return txt.startsWith("{") && txt.indexOf(125) == txt.length() - 1;
    }

    private static void setPostfix(String linePart, Function fun, int pos) {
        if (fun.hasPostfix()) {
            String funcName = VarUtils.toUpper(linePart.substring(fun.getName().length(), pos));
            if (funcName.length() > 2) {
                funcName = funcName.substring(0, 2);
            }
            fun.setFunctionName(funcName);
        } else if (pos != fun.getName().length()) {
            throw new RuntimeException("Syntax error: " + linePart);
        }
    }

    private static String cleanPart(StringBuilder sb) {
        String ret = sb.toString();
        if (VarUtils.toUpper(ret).trim().startsWith("DATA")) {
            return ret.replaceAll("^\\s*", "");
        }
        return ret.trim();
    }

    private static Function getFunction(CompilerConfig config, String linePart, Map<String, Term> termMap, Machine machine) {
        List<Function> functions = FunctionList.getFunctions();
        Function fun = null;
        for (Function function : functions) {
            if (!function.isFunction(linePart)) continue;
            fun = function.clone();
            int pos = linePart.indexOf(40);
            int pos2 = linePart.lastIndexOf(41);
            if (pos == -1 || pos2 < pos) {
                pos = linePart.indexOf(123);
                pos2 = linePart.indexOf(125);
                if (termMap == null || pos == -1 || pos2 < pos) {
                    throw new RuntimeException("Invalid function call: " + linePart);
                }
                Parser.setPostfix(linePart, fun, pos);
                fun.setTerm(Parser.createTerm(config, linePart.substring(pos, pos2 + 1), termMap, machine));
            } else {
                Parser.setPostfix(linePart, fun, pos);
                fun.parse(config, linePart.substring(pos + 1, pos2), machine);
            }
            if (!fun.typesMatch()) {
                throw new RuntimeException("Type mismatch error: " + linePart + " / " + fun.getTerm());
            }
            if (pos2 == -1 || pos2 >= linePart.length() - 1) break;
            throw new RuntimeException("Syntax error: " + linePart);
        }
        return fun;
    }

    private static void checkForInvalidChars(String term) {
        boolean inString = false;
        int i = 0;
        while (i < term.length()) {
            char c = term.charAt(i);
            if (c == '\"') {
                boolean bl = inString = !inString;
            }
            if (!inString && "&!|~?'\u00a7{}[]\u00b0".indexOf(c) != -1) {
                throw new RuntimeException("Syntax error: " + term + "/" + c);
            }
            ++i;
        }
    }

    private static String extractName(String linePart, boolean includingAssignment) {
        if (includingAssignment) {
            int pos = linePart.indexOf(61);
            if (pos == -1) {
                throw new RuntimeException("Missing assignment: " + linePart);
            }
            linePart = linePart.substring(0, pos);
        }
        return Parser.getVariableName(linePart);
    }
}

