/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.parser;

import com.sixtyfour.elements.commands.Command;
import com.sixtyfour.elements.commands.Gosub;
import com.sixtyfour.elements.commands.Goto;
import com.sixtyfour.elements.commands.If;
import com.sixtyfour.elements.commands.On;
import com.sixtyfour.parser.Parser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;

public class Preprocessor {
    private static final int INC = 10;
    private static final int START = 100;

    public static String[] convertToLineNumbers(String[] code) {
        ArrayList<String> res = new ArrayList<String>();
        ArrayList<String> tmp = new ArrayList<String>();
        HashMap<String, Integer> label2line = new HashMap<String, Integer>();
        int ln = 100;
        String[] stringArray = code;
        int n = code.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!line.isEmpty()) {
                String label;
                Command com;
                char c = line.charAt(0);
                if (Character.isDigit(c)) {
                    throw new RuntimeException("Code already contains line numbers: " + Arrays.toString(code));
                }
                int pos = line.indexOf(":");
                if (pos != -1 && ((com = Parser.getCommand(label = line.substring(0, pos).trim())) == null || label.length() > com.getName().length() && label.charAt(com.getName().length()) == '_')) {
                    label2line.put(label, ln);
                    line = line.substring(pos + 1).trim();
                    if (line.isEmpty()) {
                        line = "rem jump target";
                    }
                }
                tmp.add(line);
                ln += 10;
            }
            ++n2;
        }
        ln = 100;
        for (String line : tmp) {
            String[] parts = line.split(":");
            StringBuilder sb = new StringBuilder();
            if (parts.length > 0) {
                String[] stringArray2 = parts;
                int n3 = parts.length;
                int n4 = 0;
                while (n4 < n3) {
                    int pos;
                    Command com;
                    String part = stringArray2[n4];
                    if (sb.length() > 0) {
                        sb.append(":");
                    }
                    if ((com = Parser.getCommand(part.trim())) instanceof If) {
                        String lp = Parser.replaceStrings(part, '_').toLowerCase(Locale.ENGLISH);
                        pos = lp.indexOf("then");
                        int pos2 = lp.indexOf("goto");
                        boolean got = true;
                        if (pos2 == -1 && (pos2 = lp.indexOf("gosub")) != -1) {
                            got = false;
                        }
                        if (pos == -1) {
                            pos = pos2;
                        }
                        if (pos2 > pos) {
                            pos = pos2;
                        }
                        if (pos != -1) {
                            sb.append(part.substring(0, pos + (got ? 4 : 5))).append(" ");
                            String op = part.substring(pos + (got ? 4 : 5));
                            Integer lineNum = (Integer)label2line.get(op.trim());
                            if (lineNum != null) {
                                sb.append(lineNum);
                            } else {
                                sb.append(op);
                            }
                        } else {
                            sb.append(part);
                        }
                    } else if (com instanceof Goto || com instanceof Gosub || com instanceof On) {
                        String pl = part.toLowerCase(Locale.ENGLISH);
                        pos = pl.indexOf("goto");
                        boolean got = true;
                        if (pos == -1) {
                            pos = pl.indexOf("gosub");
                            got = false;
                        }
                        if (pos != -1) {
                            sb.append(part.substring(0, pos + (got ? 4 : 5))).append(" ");
                            String op = part.substring(pos + (got ? 4 : 5));
                            String[] targets = op.split(",");
                            int cnt = 0;
                            String[] stringArray3 = targets;
                            int n5 = targets.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                String target = stringArray3[n6];
                                Integer lineNum = (Integer)label2line.get(target.trim());
                                if (lineNum == null) {
                                    throw new RuntimeException("Label '" + target.trim() + "' not found: " + line);
                                }
                                sb.append(cnt++ == 0 ? "" : ",");
                                sb.append(lineNum);
                                ++n6;
                            }
                        }
                    } else {
                        sb.append(part);
                    }
                    ++n4;
                }
                res.add(String.valueOf(ln) + " " + sb.toString());
            } else {
                res.add(String.valueOf(ln) + " " + line);
            }
            ln += 10;
        }
        return res.toArray(new String[res.size()]);
    }
}

